# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StreamSourceDetails(object):
    """
    Details about a stream source
    """

    #: A constant which can be used with the source_type property of a StreamSourceDetails.
    #: This constant has a value of "RTSP"
    SOURCE_TYPE_RTSP = "RTSP"

    def __init__(self, **kwargs):
        """
        Initializes a new StreamSourceDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.ai_vision.models.RtspSourceDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param stream_network_access_details:
            The value to assign to the stream_network_access_details property of this StreamSourceDetails.
        :type stream_network_access_details: oci.ai_vision.models.StreamNetworkAccessDetails

        :param source_type:
            The value to assign to the source_type property of this StreamSourceDetails.
            Allowed values for this property are: "RTSP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type source_type: str

        """
        self.swagger_types = {
            'stream_network_access_details': 'StreamNetworkAccessDetails',
            'source_type': 'str'
        }
        self.attribute_map = {
            'stream_network_access_details': 'streamNetworkAccessDetails',
            'source_type': 'sourceType'
        }
        self._stream_network_access_details = None
        self._source_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['sourceType']

        if type == 'RTSP':
            return 'RtspSourceDetails'
        else:
            return 'StreamSourceDetails'

    @property
    def stream_network_access_details(self):
        """
        **[Required]** Gets the stream_network_access_details of this StreamSourceDetails.

        :return: The stream_network_access_details of this StreamSourceDetails.
        :rtype: oci.ai_vision.models.StreamNetworkAccessDetails
        """
        return self._stream_network_access_details

    @stream_network_access_details.setter
    def stream_network_access_details(self, stream_network_access_details):
        """
        Sets the stream_network_access_details of this StreamSourceDetails.

        :param stream_network_access_details: The stream_network_access_details of this StreamSourceDetails.
        :type: oci.ai_vision.models.StreamNetworkAccessDetails
        """
        self._stream_network_access_details = stream_network_access_details

    @property
    def source_type(self):
        """
        **[Required]** Gets the source_type of this StreamSourceDetails.
        Type of source
        Allowed values are:
        - RTSP

        Allowed values for this property are: "RTSP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The source_type of this StreamSourceDetails.
        :rtype: str
        """
        return self._source_type

    @source_type.setter
    def source_type(self, source_type):
        """
        Sets the source_type of this StreamSourceDetails.
        Type of source
        Allowed values are:
        - RTSP


        :param source_type: The source_type of this StreamSourceDetails.
        :type: str
        """
        allowed_values = ["RTSP"]
        if not value_allowed_none_or_none_sentinel(source_type, allowed_values):
            source_type = 'UNKNOWN_ENUM_VALUE'
        self._source_type = source_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
