# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivilegedApiRequestSummary(object):
    """
    Summary of access request.
    """

    #: A constant which can be used with the severity property of a PrivilegedApiRequestSummary.
    #: This constant has a value of "SEV_1"
    SEVERITY_SEV_1 = "SEV_1"

    #: A constant which can be used with the severity property of a PrivilegedApiRequestSummary.
    #: This constant has a value of "SEV_2"
    SEVERITY_SEV_2 = "SEV_2"

    #: A constant which can be used with the severity property of a PrivilegedApiRequestSummary.
    #: This constant has a value of "SEV_3"
    SEVERITY_SEV_3 = "SEV_3"

    #: A constant which can be used with the severity property of a PrivilegedApiRequestSummary.
    #: This constant has a value of "SEV_4"
    SEVERITY_SEV_4 = "SEV_4"

    def __init__(self, **kwargs):
        """
        Initializes a new PrivilegedApiRequestSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PrivilegedApiRequestSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this PrivilegedApiRequestSummary.
        :type display_name: str

        :param request_id:
            The value to assign to the request_id property of this PrivilegedApiRequestSummary.
        :type request_id: str

        :param reason_summary:
            The value to assign to the reason_summary property of this PrivilegedApiRequestSummary.
        :type reason_summary: str

        :param compartment_id:
            The value to assign to the compartment_id property of this PrivilegedApiRequestSummary.
        :type compartment_id: str

        :param resource_name:
            The value to assign to the resource_name property of this PrivilegedApiRequestSummary.
        :type resource_name: str

        :param resource_id:
            The value to assign to the resource_id property of this PrivilegedApiRequestSummary.
        :type resource_id: str

        :param sub_resource_name_list:
            The value to assign to the sub_resource_name_list property of this PrivilegedApiRequestSummary.
        :type sub_resource_name_list: list[str]

        :param resource_type:
            The value to assign to the resource_type property of this PrivilegedApiRequestSummary.
        :type resource_type: str

        :param privileged_operation_list:
            The value to assign to the privileged_operation_list property of this PrivilegedApiRequestSummary.
        :type privileged_operation_list: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]

        :param state:
            The value to assign to the state property of this PrivilegedApiRequestSummary.
        :type state: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PrivilegedApiRequestSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this PrivilegedApiRequestSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this PrivilegedApiRequestSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this PrivilegedApiRequestSummary.
        :type time_updated: datetime

        :param duration_in_hrs:
            The value to assign to the duration_in_hrs property of this PrivilegedApiRequestSummary.
        :type duration_in_hrs: int

        :param severity:
            The value to assign to the severity property of this PrivilegedApiRequestSummary.
            Allowed values for this property are: "SEV_1", "SEV_2", "SEV_3", "SEV_4", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param time_requested_for_future_access:
            The value to assign to the time_requested_for_future_access property of this PrivilegedApiRequestSummary.
        :type time_requested_for_future_access: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PrivilegedApiRequestSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this PrivilegedApiRequestSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this PrivilegedApiRequestSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'request_id': 'str',
            'reason_summary': 'str',
            'compartment_id': 'str',
            'resource_name': 'str',
            'resource_id': 'str',
            'sub_resource_name_list': 'list[str]',
            'resource_type': 'str',
            'privileged_operation_list': 'list[PrivilegedApiRequestOperationDetails]',
            'state': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'duration_in_hrs': 'int',
            'severity': 'str',
            'time_requested_for_future_access': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'request_id': 'requestId',
            'reason_summary': 'reasonSummary',
            'compartment_id': 'compartmentId',
            'resource_name': 'resourceName',
            'resource_id': 'resourceId',
            'sub_resource_name_list': 'subResourceNameList',
            'resource_type': 'resourceType',
            'privileged_operation_list': 'privilegedOperationList',
            'state': 'state',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'duration_in_hrs': 'durationInHrs',
            'severity': 'severity',
            'time_requested_for_future_access': 'timeRequestedForFutureAccess',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._request_id = None
        self._reason_summary = None
        self._compartment_id = None
        self._resource_name = None
        self._resource_id = None
        self._sub_resource_name_list = None
        self._resource_type = None
        self._privileged_operation_list = None
        self._state = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._duration_in_hrs = None
        self._severity = None
        self._time_requested_for_future_access = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PrivilegedApiRequestSummary.
        The OCID of the access request.


        :return: The id of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PrivilegedApiRequestSummary.
        The OCID of the access request.


        :param id: The id of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this PrivilegedApiRequestSummary.
        Name of the privilegedApi control. The name must be unique.


        :return: The display_name of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PrivilegedApiRequestSummary.
        Name of the privilegedApi control. The name must be unique.


        :param display_name: The display_name of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def request_id(self):
        """
        Gets the request_id of this PrivilegedApiRequestSummary.
        This is a system-generated identifier to identity a Request in human readable form in the form of REQYYYYMMDD<number>.


        :return: The request_id of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """
        Sets the request_id of this PrivilegedApiRequestSummary.
        This is a system-generated identifier to identity a Request in human readable form in the form of REQYYYYMMDD<number>.


        :param request_id: The request_id of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._request_id = request_id

    @property
    def reason_summary(self):
        """
        **[Required]** Gets the reason_summary of this PrivilegedApiRequestSummary.
        Comment associated with the privilegedApi request.


        :return: The reason_summary of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._reason_summary

    @reason_summary.setter
    def reason_summary(self, reason_summary):
        """
        Sets the reason_summary of this PrivilegedApiRequestSummary.
        Comment associated with the privilegedApi request.


        :param reason_summary: The reason_summary of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._reason_summary = reason_summary

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this PrivilegedApiRequestSummary.
        The OCID of the compartment that contains the privilegedApi request.


        :return: The compartment_id of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PrivilegedApiRequestSummary.
        The OCID of the compartment that contains the privilegedApi request.


        :param compartment_id: The compartment_id of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_name(self):
        """
        Gets the resource_name of this PrivilegedApiRequestSummary.
        resourceName for which the PrivilegedApiRequest is applicable


        :return: The resource_name of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this PrivilegedApiRequestSummary.
        resourceName for which the PrivilegedApiRequest is applicable


        :param resource_name: The resource_name of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this PrivilegedApiRequestSummary.
        The OCID of the target resource associated with the privilegedApi request. The operator raises an privilegedApi request to get approval to access the target resource.


        :return: The resource_id of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this PrivilegedApiRequestSummary.
        The OCID of the target resource associated with the privilegedApi request. The operator raises an privilegedApi request to get approval to access the target resource.


        :param resource_id: The resource_id of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def sub_resource_name_list(self):
        """
        Gets the sub_resource_name_list of this PrivilegedApiRequestSummary.
        The subresource names requested for approval.


        :return: The sub_resource_name_list of this PrivilegedApiRequestSummary.
        :rtype: list[str]
        """
        return self._sub_resource_name_list

    @sub_resource_name_list.setter
    def sub_resource_name_list(self, sub_resource_name_list):
        """
        Sets the sub_resource_name_list of this PrivilegedApiRequestSummary.
        The subresource names requested for approval.


        :param sub_resource_name_list: The sub_resource_name_list of this PrivilegedApiRequestSummary.
        :type: list[str]
        """
        self._sub_resource_name_list = sub_resource_name_list

    @property
    def resource_type(self):
        """
        Gets the resource_type of this PrivilegedApiRequestSummary.
        resourceType for which the PrivilegedApiRequest is applicable


        :return: The resource_type of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this PrivilegedApiRequestSummary.
        resourceType for which the PrivilegedApiRequest is applicable


        :param resource_type: The resource_type of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def privileged_operation_list(self):
        """
        Gets the privileged_operation_list of this PrivilegedApiRequestSummary.
        List of api names, attributes for which approval is sought by the user.


        :return: The privileged_operation_list of this PrivilegedApiRequestSummary.
        :rtype: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]
        """
        return self._privileged_operation_list

    @privileged_operation_list.setter
    def privileged_operation_list(self, privileged_operation_list):
        """
        Sets the privileged_operation_list of this PrivilegedApiRequestSummary.
        List of api names, attributes for which approval is sought by the user.


        :param privileged_operation_list: The privileged_operation_list of this PrivilegedApiRequestSummary.
        :type: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]
        """
        self._privileged_operation_list = privileged_operation_list

    @property
    def state(self):
        """
        Gets the state of this PrivilegedApiRequestSummary.
        The current state of the Access Request.


        :return: The state of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this PrivilegedApiRequestSummary.
        The current state of the Access Request.


        :param state: The state of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._state = state

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this PrivilegedApiRequestSummary.
        The current state of the PrivilegedApiRequest.


        :return: The lifecycle_state of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PrivilegedApiRequestSummary.
        The current state of the PrivilegedApiRequest.


        :param lifecycle_state: The lifecycle_state of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this PrivilegedApiRequestSummary.
        More in detail about the lifeCycleState.


        :return: The lifecycle_details of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this PrivilegedApiRequestSummary.
        More in detail about the lifeCycleState.


        :param lifecycle_details: The lifecycle_details of this PrivilegedApiRequestSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        Gets the time_created of this PrivilegedApiRequestSummary.
        Time when the privilegedApi request was created by the operator user in `RFC 3339`__ timestamp format.Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this PrivilegedApiRequestSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PrivilegedApiRequestSummary.
        Time when the privilegedApi request was created by the operator user in `RFC 3339`__ timestamp format.Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this PrivilegedApiRequestSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this PrivilegedApiRequestSummary.
        Time when the privilegedApi request was last modified in `RFC 3339`__ timestamp format.Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this PrivilegedApiRequestSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PrivilegedApiRequestSummary.
        Time when the privilegedApi request was last modified in `RFC 3339`__ timestamp format.Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this PrivilegedApiRequestSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def duration_in_hrs(self):
        """
        Gets the duration_in_hrs of this PrivilegedApiRequestSummary.
        Duration in hours for which access is sought on the target resource.


        :return: The duration_in_hrs of this PrivilegedApiRequestSummary.
        :rtype: int
        """
        return self._duration_in_hrs

    @duration_in_hrs.setter
    def duration_in_hrs(self, duration_in_hrs):
        """
        Sets the duration_in_hrs of this PrivilegedApiRequestSummary.
        Duration in hours for which access is sought on the target resource.


        :param duration_in_hrs: The duration_in_hrs of this PrivilegedApiRequestSummary.
        :type: int
        """
        self._duration_in_hrs = duration_in_hrs

    @property
    def severity(self):
        """
        Gets the severity of this PrivilegedApiRequestSummary.
        Priority assigned to the privilegedApi request by the operator

        Allowed values for this property are: "SEV_1", "SEV_2", "SEV_3", "SEV_4", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this PrivilegedApiRequestSummary.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this PrivilegedApiRequestSummary.
        Priority assigned to the privilegedApi request by the operator


        :param severity: The severity of this PrivilegedApiRequestSummary.
        :type: str
        """
        allowed_values = ["SEV_1", "SEV_2", "SEV_3", "SEV_4"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def time_requested_for_future_access(self):
        """
        Gets the time_requested_for_future_access of this PrivilegedApiRequestSummary.
        Time in future when the user for the access request needs to be created in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_requested_for_future_access of this PrivilegedApiRequestSummary.
        :rtype: datetime
        """
        return self._time_requested_for_future_access

    @time_requested_for_future_access.setter
    def time_requested_for_future_access(self, time_requested_for_future_access):
        """
        Sets the time_requested_for_future_access of this PrivilegedApiRequestSummary.
        Time in future when the user for the access request needs to be created in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_requested_for_future_access: The time_requested_for_future_access of this PrivilegedApiRequestSummary.
        :type: datetime
        """
        self._time_requested_for_future_access = time_requested_for_future_access

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this PrivilegedApiRequestSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this PrivilegedApiRequestSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PrivilegedApiRequestSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this PrivilegedApiRequestSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this PrivilegedApiRequestSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this PrivilegedApiRequestSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PrivilegedApiRequestSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this PrivilegedApiRequestSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this PrivilegedApiRequestSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this PrivilegedApiRequestSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PrivilegedApiRequestSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this PrivilegedApiRequestSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
