# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentConfigMap(object):
    """
    Collection of agent configuration files.
    For agents that use a single configuration file, this SHOULD contain a single entry and the key MAY be an empty string.
    To apply a different configuration in a subset of the agents, put this block anywhere in the body of the configuration and edit <some variable> and <some content>
    {{ <some variable> | default <some content> }}
    Example:
    com.oracle.apm.agent.tracer.enable.jfr = {{ isJfrEnabled | default false }}
    Then, in the configuration's overrides, specify a different value for <some variable> along with the desired agent filter.
    Example:
    \"agentFilter\": \"ApplicationType='Tomcat'\"
    \"overrideMap\": {
    \"isJfrEnabled\": true
    }
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgentConfigMap object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_map:
            The value to assign to the config_map property of this AgentConfigMap.
        :type config_map: dict(str, AgentConfigFile)

        """
        self.swagger_types = {
            'config_map': 'dict(str, AgentConfigFile)'
        }
        self.attribute_map = {
            'config_map': 'configMap'
        }
        self._config_map = None

    @property
    def config_map(self):
        """
        Gets the config_map of this AgentConfigMap.
        Map of agent configuration files, where keys are file names.


        :return: The config_map of this AgentConfigMap.
        :rtype: dict(str, AgentConfigFile)
        """
        return self._config_map

    @config_map.setter
    def config_map(self, config_map):
        """
        Sets the config_map of this AgentConfigMap.
        Map of agent configuration files, where keys are file names.


        :param config_map: The config_map of this AgentConfigMap.
        :type: dict(str, AgentConfigFile)
        """
        self._config_map = config_map

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
