# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AvailableCapability(object):
    """
    Available capability in a specific On-premise vantage point.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AvailableCapability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param capability:
            The value to assign to the capability property of this AvailableCapability.
        :type capability: str

        :param count:
            The value to assign to the count property of this AvailableCapability.
        :type count: int

        """
        self.swagger_types = {
            'capability': 'str',
            'count': 'int'
        }
        self.attribute_map = {
            'capability': 'capability',
            'count': 'count'
        }
        self._capability = None
        self._count = None

    @property
    def capability(self):
        """
        **[Required]** Gets the capability of this AvailableCapability.
        Capability of an On-premise vantage point worker.


        :return: The capability of this AvailableCapability.
        :rtype: str
        """
        return self._capability

    @capability.setter
    def capability(self, capability):
        """
        Sets the capability of this AvailableCapability.
        Capability of an On-premise vantage point worker.


        :param capability: The capability of this AvailableCapability.
        :type: str
        """
        self._capability = capability

    @property
    def count(self):
        """
        **[Required]** Gets the count of this AvailableCapability.
        Count of available capability in a specific On-premise vantage point.


        :return: The count of this AvailableCapability.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this AvailableCapability.
        Count of available capability in a specific On-premise vantage point.


        :param count: The count of this AvailableCapability.
        :type: int
        """
        self._count = count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
