# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OnPremiseVpWorkerVersionDetails(object):
    """
    Image version details of the On-premise VP worker.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OnPremiseVpWorkerVersionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param version:
            The value to assign to the version property of this OnPremiseVpWorkerVersionDetails.
        :type version: str

        :param min_supported_version:
            The value to assign to the min_supported_version property of this OnPremiseVpWorkerVersionDetails.
        :type min_supported_version: str

        :param latest_version:
            The value to assign to the latest_version property of this OnPremiseVpWorkerVersionDetails.
        :type latest_version: str

        """
        self.swagger_types = {
            'version': 'str',
            'min_supported_version': 'str',
            'latest_version': 'str'
        }
        self.attribute_map = {
            'version': 'version',
            'min_supported_version': 'minSupportedVersion',
            'latest_version': 'latestVersion'
        }
        self._version = None
        self._min_supported_version = None
        self._latest_version = None

    @property
    def version(self):
        """
        **[Required]** Gets the version of this OnPremiseVpWorkerVersionDetails.
        Current image version of the On-premise VP worker.


        :return: The version of this OnPremiseVpWorkerVersionDetails.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this OnPremiseVpWorkerVersionDetails.
        Current image version of the On-premise VP worker.


        :param version: The version of this OnPremiseVpWorkerVersionDetails.
        :type: str
        """
        self._version = version

    @property
    def min_supported_version(self):
        """
        **[Required]** Gets the min_supported_version of this OnPremiseVpWorkerVersionDetails.
        Minimum supported image version of the On-premise VP worker.


        :return: The min_supported_version of this OnPremiseVpWorkerVersionDetails.
        :rtype: str
        """
        return self._min_supported_version

    @min_supported_version.setter
    def min_supported_version(self, min_supported_version):
        """
        Sets the min_supported_version of this OnPremiseVpWorkerVersionDetails.
        Minimum supported image version of the On-premise VP worker.


        :param min_supported_version: The min_supported_version of this OnPremiseVpWorkerVersionDetails.
        :type: str
        """
        self._min_supported_version = min_supported_version

    @property
    def latest_version(self):
        """
        **[Required]** Gets the latest_version of this OnPremiseVpWorkerVersionDetails.
        Latest image version of the On-premise VP worker.


        :return: The latest_version of this OnPremiseVpWorkerVersionDetails.
        :rtype: str
        """
        return self._latest_version

    @latest_version.setter
    def latest_version(self, latest_version):
        """
        Sets the latest_version of this OnPremiseVpWorkerVersionDetails.
        Latest image version of the On-premise VP worker.


        :param latest_version: The latest_version of this OnPremiseVpWorkerVersionDetails.
        :type: str
        """
        self._latest_version = latest_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
