# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkActivateAttributeDetail(object):
    """
    Object that contains the details about a single attribute in the bulk request to be activated.  The attributeNameSpace and
    unit are optional parameters, and the attributeNameSpace will default to TRACES if it is not passed in.
    """

    #: A constant which can be used with the attribute_type property of a BulkActivateAttributeDetail.
    #: This constant has a value of "NUMERIC"
    ATTRIBUTE_TYPE_NUMERIC = "NUMERIC"

    #: A constant which can be used with the attribute_type property of a BulkActivateAttributeDetail.
    #: This constant has a value of "STRING"
    ATTRIBUTE_TYPE_STRING = "STRING"

    #: A constant which can be used with the attribute_type property of a BulkActivateAttributeDetail.
    #: This constant has a value of "NONE"
    ATTRIBUTE_TYPE_NONE = "NONE"

    #: A constant which can be used with the unit property of a BulkActivateAttributeDetail.
    #: This constant has a value of "NONE"
    UNIT_NONE = "NONE"

    #: A constant which can be used with the unit property of a BulkActivateAttributeDetail.
    #: This constant has a value of "EPOCH_TIME_MS"
    UNIT_EPOCH_TIME_MS = "EPOCH_TIME_MS"

    #: A constant which can be used with the unit property of a BulkActivateAttributeDetail.
    #: This constant has a value of "BYTES"
    UNIT_BYTES = "BYTES"

    #: A constant which can be used with the unit property of a BulkActivateAttributeDetail.
    #: This constant has a value of "COUNT"
    UNIT_COUNT = "COUNT"

    #: A constant which can be used with the unit property of a BulkActivateAttributeDetail.
    #: This constant has a value of "DURATION_MS"
    UNIT_DURATION_MS = "DURATION_MS"

    #: A constant which can be used with the unit property of a BulkActivateAttributeDetail.
    #: This constant has a value of "TRACE_STATUS"
    UNIT_TRACE_STATUS = "TRACE_STATUS"

    #: A constant which can be used with the unit property of a BulkActivateAttributeDetail.
    #: This constant has a value of "PERCENTAGE"
    UNIT_PERCENTAGE = "PERCENTAGE"

    #: A constant which can be used with the attribute_name_space property of a BulkActivateAttributeDetail.
    #: This constant has a value of "TRACES"
    ATTRIBUTE_NAME_SPACE_TRACES = "TRACES"

    #: A constant which can be used with the attribute_name_space property of a BulkActivateAttributeDetail.
    #: This constant has a value of "SYNTHETIC"
    ATTRIBUTE_NAME_SPACE_SYNTHETIC = "SYNTHETIC"

    #: A constant which can be used with the attribute_name_space property of a BulkActivateAttributeDetail.
    #: This constant has a value of "LOGS"
    ATTRIBUTE_NAME_SPACE_LOGS = "LOGS"

    def __init__(self, **kwargs):
        """
        Initializes a new BulkActivateAttributeDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute_name:
            The value to assign to the attribute_name property of this BulkActivateAttributeDetail.
        :type attribute_name: str

        :param attribute_type:
            The value to assign to the attribute_type property of this BulkActivateAttributeDetail.
            Allowed values for this property are: "NUMERIC", "STRING", "NONE"
        :type attribute_type: str

        :param attribute_expression:
            The value to assign to the attribute_expression property of this BulkActivateAttributeDetail.
        :type attribute_expression: str

        :param unit:
            The value to assign to the unit property of this BulkActivateAttributeDetail.
            Allowed values for this property are: "NONE", "EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "TRACE_STATUS", "PERCENTAGE"
        :type unit: str

        :param attribute_name_space:
            The value to assign to the attribute_name_space property of this BulkActivateAttributeDetail.
            Allowed values for this property are: "TRACES", "SYNTHETIC", "LOGS"
        :type attribute_name_space: str

        """
        self.swagger_types = {
            'attribute_name': 'str',
            'attribute_type': 'str',
            'attribute_expression': 'str',
            'unit': 'str',
            'attribute_name_space': 'str'
        }
        self.attribute_map = {
            'attribute_name': 'attributeName',
            'attribute_type': 'attributeType',
            'attribute_expression': 'attributeExpression',
            'unit': 'unit',
            'attribute_name_space': 'attributeNameSpace'
        }
        self._attribute_name = None
        self._attribute_type = None
        self._attribute_expression = None
        self._unit = None
        self._attribute_name_space = None

    @property
    def attribute_name(self):
        """
        **[Required]** Gets the attribute_name of this BulkActivateAttributeDetail.
        Name of the attribute to be activated.


        :return: The attribute_name of this BulkActivateAttributeDetail.
        :rtype: str
        """
        return self._attribute_name

    @attribute_name.setter
    def attribute_name(self, attribute_name):
        """
        Sets the attribute_name of this BulkActivateAttributeDetail.
        Name of the attribute to be activated.


        :param attribute_name: The attribute_name of this BulkActivateAttributeDetail.
        :type: str
        """
        self._attribute_name = attribute_name

    @property
    def attribute_type(self):
        """
        **[Required]** Gets the attribute_type of this BulkActivateAttributeDetail.
        Type of the attribute to be activated.

        Allowed values for this property are: "NUMERIC", "STRING", "NONE"


        :return: The attribute_type of this BulkActivateAttributeDetail.
        :rtype: str
        """
        return self._attribute_type

    @attribute_type.setter
    def attribute_type(self, attribute_type):
        """
        Sets the attribute_type of this BulkActivateAttributeDetail.
        Type of the attribute to be activated.


        :param attribute_type: The attribute_type of this BulkActivateAttributeDetail.
        :type: str
        """
        allowed_values = ["NUMERIC", "STRING", "NONE"]
        if not value_allowed_none_or_none_sentinel(attribute_type, allowed_values):
            raise ValueError(
                f"Invalid value for `attribute_type`, must be None or one of {allowed_values}"
            )
        self._attribute_type = attribute_type

    @property
    def attribute_expression(self):
        """
        Gets the attribute_expression of this BulkActivateAttributeDetail.
        Attribute expression if this attribute is an alias


        :return: The attribute_expression of this BulkActivateAttributeDetail.
        :rtype: str
        """
        return self._attribute_expression

    @attribute_expression.setter
    def attribute_expression(self, attribute_expression):
        """
        Sets the attribute_expression of this BulkActivateAttributeDetail.
        Attribute expression if this attribute is an alias


        :param attribute_expression: The attribute_expression of this BulkActivateAttributeDetail.
        :type: str
        """
        self._attribute_expression = attribute_expression

    @property
    def unit(self):
        """
        Gets the unit of this BulkActivateAttributeDetail.
        Unit of the attribute to be updated.  If unit is not specified, it defaults to NONE.

        Allowed values for this property are: "NONE", "EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "TRACE_STATUS", "PERCENTAGE"


        :return: The unit of this BulkActivateAttributeDetail.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this BulkActivateAttributeDetail.
        Unit of the attribute to be updated.  If unit is not specified, it defaults to NONE.


        :param unit: The unit of this BulkActivateAttributeDetail.
        :type: str
        """
        allowed_values = ["NONE", "EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "TRACE_STATUS", "PERCENTAGE"]
        if not value_allowed_none_or_none_sentinel(unit, allowed_values):
            raise ValueError(
                f"Invalid value for `unit`, must be None or one of {allowed_values}"
            )
        self._unit = unit

    @property
    def attribute_name_space(self):
        """
        Gets the attribute_name_space of this BulkActivateAttributeDetail.
        Namespace of the attribute to be activated.  The attributeNameSpace will default to TRACES if it is
        not passed in.

        Allowed values for this property are: "TRACES", "SYNTHETIC", "LOGS"


        :return: The attribute_name_space of this BulkActivateAttributeDetail.
        :rtype: str
        """
        return self._attribute_name_space

    @attribute_name_space.setter
    def attribute_name_space(self, attribute_name_space):
        """
        Sets the attribute_name_space of this BulkActivateAttributeDetail.
        Namespace of the attribute to be activated.  The attributeNameSpace will default to TRACES if it is
        not passed in.


        :param attribute_name_space: The attribute_name_space of this BulkActivateAttributeDetail.
        :type: str
        """
        allowed_values = ["TRACES", "SYNTHETIC", "LOGS"]
        if not value_allowed_none_or_none_sentinel(attribute_name_space, allowed_values):
            raise ValueError(
                f"Invalid value for `attribute_name_space`, must be None or one of {allowed_values}"
            )
        self._attribute_name_space = attribute_name_space

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
