# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkUpdateAttributeNotesDetail(object):
    """
    Object that contains the details about a single attribute in the bulk request for which notes are to be updated.
    """

    #: A constant which can be used with the attribute_name_space property of a BulkUpdateAttributeNotesDetail.
    #: This constant has a value of "TRACES"
    ATTRIBUTE_NAME_SPACE_TRACES = "TRACES"

    #: A constant which can be used with the attribute_name_space property of a BulkUpdateAttributeNotesDetail.
    #: This constant has a value of "SYNTHETIC"
    ATTRIBUTE_NAME_SPACE_SYNTHETIC = "SYNTHETIC"

    #: A constant which can be used with the attribute_name_space property of a BulkUpdateAttributeNotesDetail.
    #: This constant has a value of "LOGS"
    ATTRIBUTE_NAME_SPACE_LOGS = "LOGS"

    def __init__(self, **kwargs):
        """
        Initializes a new BulkUpdateAttributeNotesDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute_name:
            The value to assign to the attribute_name property of this BulkUpdateAttributeNotesDetail.
        :type attribute_name: str

        :param notes:
            The value to assign to the notes property of this BulkUpdateAttributeNotesDetail.
        :type notes: str

        :param attribute_name_space:
            The value to assign to the attribute_name_space property of this BulkUpdateAttributeNotesDetail.
            Allowed values for this property are: "TRACES", "SYNTHETIC", "LOGS"
        :type attribute_name_space: str

        """
        self.swagger_types = {
            'attribute_name': 'str',
            'notes': 'str',
            'attribute_name_space': 'str'
        }
        self.attribute_map = {
            'attribute_name': 'attributeName',
            'notes': 'notes',
            'attribute_name_space': 'attributeNameSpace'
        }
        self._attribute_name = None
        self._notes = None
        self._attribute_name_space = None

    @property
    def attribute_name(self):
        """
        **[Required]** Gets the attribute_name of this BulkUpdateAttributeNotesDetail.
        Name of the attribute for which notes are to be updated.


        :return: The attribute_name of this BulkUpdateAttributeNotesDetail.
        :rtype: str
        """
        return self._attribute_name

    @attribute_name.setter
    def attribute_name(self, attribute_name):
        """
        Sets the attribute_name of this BulkUpdateAttributeNotesDetail.
        Name of the attribute for which notes are to be updated.


        :param attribute_name: The attribute_name of this BulkUpdateAttributeNotesDetail.
        :type: str
        """
        self._attribute_name = attribute_name

    @property
    def notes(self):
        """
        **[Required]** Gets the notes of this BulkUpdateAttributeNotesDetail.
        Notes to be updated.  The size of notes cannot exceed 1000 chars.


        :return: The notes of this BulkUpdateAttributeNotesDetail.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this BulkUpdateAttributeNotesDetail.
        Notes to be updated.  The size of notes cannot exceed 1000 chars.


        :param notes: The notes of this BulkUpdateAttributeNotesDetail.
        :type: str
        """
        self._notes = notes

    @property
    def attribute_name_space(self):
        """
        Gets the attribute_name_space of this BulkUpdateAttributeNotesDetail.
        Namespace of the attribute for which the notes are to be updated.  The attributeNameSpace will default to TRACES if it is
        not passed in.

        Allowed values for this property are: "TRACES", "SYNTHETIC", "LOGS"


        :return: The attribute_name_space of this BulkUpdateAttributeNotesDetail.
        :rtype: str
        """
        return self._attribute_name_space

    @attribute_name_space.setter
    def attribute_name_space(self, attribute_name_space):
        """
        Sets the attribute_name_space of this BulkUpdateAttributeNotesDetail.
        Namespace of the attribute for which the notes are to be updated.  The attributeNameSpace will default to TRACES if it is
        not passed in.


        :param attribute_name_space: The attribute_name_space of this BulkUpdateAttributeNotesDetail.
        :type: str
        """
        allowed_values = ["TRACES", "SYNTHETIC", "LOGS"]
        if not value_allowed_none_or_none_sentinel(attribute_name_space, allowed_values):
            raise ValueError(
                f"Invalid value for `attribute_name_space`, must be None or one of {allowed_values}"
            )
        self._attribute_name_space = attribute_name_space

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
