# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Log(object):
    """
    Definition of a log object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Log object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param log_key:
            The value to assign to the log_key property of this Log.
        :type log_key: str

        :param event_name:
            The value to assign to the event_name property of this Log.
        :type event_name: str

        :param timestamp:
            The value to assign to the timestamp property of this Log.
        :type timestamp: datetime

        :param trace_key:
            The value to assign to the trace_key property of this Log.
        :type trace_key: str

        :param span_key:
            The value to assign to the span_key property of this Log.
        :type span_key: str

        :param trace_flags:
            The value to assign to the trace_flags property of this Log.
        :type trace_flags: int

        :param time_created:
            The value to assign to the time_created property of this Log.
        :type time_created: datetime

        :param time_observed:
            The value to assign to the time_observed property of this Log.
        :type time_observed: datetime

        :param severity_text:
            The value to assign to the severity_text property of this Log.
        :type severity_text: str

        :param severity_number:
            The value to assign to the severity_number property of this Log.
        :type severity_number: int

        :param body:
            The value to assign to the body property of this Log.
        :type body: str

        :param overflow_attributes:
            The value to assign to the overflow_attributes property of this Log.
        :type overflow_attributes: str

        :param attributes:
            The value to assign to the attributes property of this Log.
        :type attributes: list[oci.apm_traces.models.Attribute]

        :param attribute_metadata:
            The value to assign to the attribute_metadata property of this Log.
        :type attribute_metadata: dict(str, AttributeMetadata)

        """
        self.swagger_types = {
            'log_key': 'str',
            'event_name': 'str',
            'timestamp': 'datetime',
            'trace_key': 'str',
            'span_key': 'str',
            'trace_flags': 'int',
            'time_created': 'datetime',
            'time_observed': 'datetime',
            'severity_text': 'str',
            'severity_number': 'int',
            'body': 'str',
            'overflow_attributes': 'str',
            'attributes': 'list[Attribute]',
            'attribute_metadata': 'dict(str, AttributeMetadata)'
        }
        self.attribute_map = {
            'log_key': 'logKey',
            'event_name': 'eventName',
            'timestamp': 'timestamp',
            'trace_key': 'traceKey',
            'span_key': 'spanKey',
            'trace_flags': 'traceFlags',
            'time_created': 'timeCreated',
            'time_observed': 'timeObserved',
            'severity_text': 'severityText',
            'severity_number': 'severityNumber',
            'body': 'body',
            'overflow_attributes': 'overflowAttributes',
            'attributes': 'attributes',
            'attribute_metadata': 'attributeMetadata'
        }
        self._log_key = None
        self._event_name = None
        self._timestamp = None
        self._trace_key = None
        self._span_key = None
        self._trace_flags = None
        self._time_created = None
        self._time_observed = None
        self._severity_text = None
        self._severity_number = None
        self._body = None
        self._overflow_attributes = None
        self._attributes = None
        self._attribute_metadata = None

    @property
    def log_key(self):
        """
        **[Required]** Gets the log_key of this Log.
        Unique identifier (logId) for the logKey.  Note that this field is
        defined as logKey in the API and it maps to the logId in Application Performance Monitoring.


        :return: The log_key of this Log.
        :rtype: str
        """
        return self._log_key

    @log_key.setter
    def log_key(self, log_key):
        """
        Sets the log_key of this Log.
        Unique identifier (logId) for the logKey.  Note that this field is
        defined as logKey in the API and it maps to the logId in Application Performance Monitoring.


        :param log_key: The log_key of this Log.
        :type: str
        """
        self._log_key = log_key

    @property
    def event_name(self):
        """
        Gets the event_name of this Log.
        Name of the event.


        :return: The event_name of this Log.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name):
        """
        Sets the event_name of this Log.
        Name of the event.


        :param event_name: The event_name of this Log.
        :type: str
        """
        self._event_name = event_name

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this Log.
        Time used by the time picker (RecordedTime).  Either the timeCreated if present or the timeObserved.


        :return: The timestamp of this Log.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Log.
        Time used by the time picker (RecordedTime).  Either the timeCreated if present or the timeObserved.


        :param timestamp: The timestamp of this Log.
        :type: datetime
        """
        self._timestamp = timestamp

    @property
    def trace_key(self):
        """
        Gets the trace_key of this Log.
        Unique identifier for the trace (traceId) associated with this log.


        :return: The trace_key of this Log.
        :rtype: str
        """
        return self._trace_key

    @trace_key.setter
    def trace_key(self, trace_key):
        """
        Sets the trace_key of this Log.
        Unique identifier for the trace (traceId) associated with this log.


        :param trace_key: The trace_key of this Log.
        :type: str
        """
        self._trace_key = trace_key

    @property
    def span_key(self):
        """
        Gets the span_key of this Log.
        Unique identifier for the span (spanId) associated with this log.


        :return: The span_key of this Log.
        :rtype: str
        """
        return self._span_key

    @span_key.setter
    def span_key(self, span_key):
        """
        Sets the span_key of this Log.
        Unique identifier for the span (spanId) associated with this log.


        :param span_key: The span_key of this Log.
        :type: str
        """
        self._span_key = span_key

    @property
    def trace_flags(self):
        """
        Gets the trace_flags of this Log.
        Trace flags.


        :return: The trace_flags of this Log.
        :rtype: int
        """
        return self._trace_flags

    @trace_flags.setter
    def trace_flags(self, trace_flags):
        """
        Sets the trace_flags of this Log.
        Trace flags.


        :param trace_flags: The trace_flags of this Log.
        :type: int
        """
        self._trace_flags = trace_flags

    @property
    def time_created(self):
        """
        Gets the time_created of this Log.
        Time that the log event occurred (CreatedTime).


        :return: The time_created of this Log.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Log.
        Time that the log event occurred (CreatedTime).


        :param time_created: The time_created of this Log.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_observed(self):
        """
        Gets the time_observed of this Log.
        Time that the log was received by apm (ObservedTime).


        :return: The time_observed of this Log.
        :rtype: datetime
        """
        return self._time_observed

    @time_observed.setter
    def time_observed(self, time_observed):
        """
        Sets the time_observed of this Log.
        Time that the log was received by apm (ObservedTime).


        :param time_observed: The time_observed of this Log.
        :type: datetime
        """
        self._time_observed = time_observed

    @property
    def severity_text(self):
        """
        Gets the severity_text of this Log.
        Log Severity text (SeverityText).  Also known as Log level.


        :return: The severity_text of this Log.
        :rtype: str
        """
        return self._severity_text

    @severity_text.setter
    def severity_text(self, severity_text):
        """
        Sets the severity_text of this Log.
        Log Severity text (SeverityText).  Also known as Log level.


        :param severity_text: The severity_text of this Log.
        :type: str
        """
        self._severity_text = severity_text

    @property
    def severity_number(self):
        """
        Gets the severity_number of this Log.
        Log Severity number (SeverityNumber).


        :return: The severity_number of this Log.
        :rtype: int
        """
        return self._severity_number

    @severity_number.setter
    def severity_number(self, severity_number):
        """
        Sets the severity_number of this Log.
        Log Severity number (SeverityNumber).


        :param severity_number: The severity_number of this Log.
        :type: int
        """
        self._severity_number = severity_number

    @property
    def body(self):
        """
        Gets the body of this Log.
        Log body (Body).


        :return: The body of this Log.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this Log.
        Log body (Body).


        :param body: The body of this Log.
        :type: str
        """
        self._body = body

    @property
    def overflow_attributes(self):
        """
        Gets the overflow_attributes of this Log.
        Full values for attributes that are too long to be stored as a log attribute (Overflow).


        :return: The overflow_attributes of this Log.
        :rtype: str
        """
        return self._overflow_attributes

    @overflow_attributes.setter
    def overflow_attributes(self, overflow_attributes):
        """
        Sets the overflow_attributes of this Log.
        Full values for attributes that are too long to be stored as a log attribute (Overflow).


        :param overflow_attributes: The overflow_attributes of this Log.
        :type: str
        """
        self._overflow_attributes = overflow_attributes

    @property
    def attributes(self):
        """
        Gets the attributes of this Log.
        List of attributes associated with the logs.


        :return: The attributes of this Log.
        :rtype: list[oci.apm_traces.models.Attribute]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this Log.
        List of attributes associated with the logs.


        :param attributes: The attributes of this Log.
        :type: list[oci.apm_traces.models.Attribute]
        """
        self._attributes = attributes

    @property
    def attribute_metadata(self):
        """
        Gets the attribute_metadata of this Log.
        Metadata about the attributes in the logs.


        :return: The attribute_metadata of this Log.
        :rtype: dict(str, AttributeMetadata)
        """
        return self._attribute_metadata

    @attribute_metadata.setter
    def attribute_metadata(self, attribute_metadata):
        """
        Sets the attribute_metadata of this Log.
        Metadata about the attributes in the logs.


        :param attribute_metadata: The attribute_metadata of this Log.
        :type: dict(str, AttributeMetadata)
        """
        self._attribute_metadata = attribute_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
