# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduledQuery(object):
    """
    Scheduled Query object.
    """

    #: A constant which can be used with the scheduled_query_processing_type property of a ScheduledQuery.
    #: This constant has a value of "EXPORT"
    SCHEDULED_QUERY_PROCESSING_TYPE_EXPORT = "EXPORT"

    #: A constant which can be used with the scheduled_query_processing_type property of a ScheduledQuery.
    #: This constant has a value of "QUERY"
    SCHEDULED_QUERY_PROCESSING_TYPE_QUERY = "QUERY"

    #: A constant which can be used with the scheduled_query_processing_type property of a ScheduledQuery.
    #: This constant has a value of "ALERT"
    SCHEDULED_QUERY_PROCESSING_TYPE_ALERT = "ALERT"

    #: A constant which can be used with the scheduled_query_processing_sub_type property of a ScheduledQuery.
    #: This constant has a value of "OBJECT_STORAGE"
    SCHEDULED_QUERY_PROCESSING_SUB_TYPE_OBJECT_STORAGE = "OBJECT_STORAGE"

    #: A constant which can be used with the scheduled_query_processing_sub_type property of a ScheduledQuery.
    #: This constant has a value of "STREAMING"
    SCHEDULED_QUERY_PROCESSING_SUB_TYPE_STREAMING = "STREAMING"

    #: A constant which can be used with the scheduled_query_processing_sub_type property of a ScheduledQuery.
    #: This constant has a value of "CUSTOM_METRIC"
    SCHEDULED_QUERY_PROCESSING_SUB_TYPE_CUSTOM_METRIC = "CUSTOM_METRIC"

    #: A constant which can be used with the scheduled_query_processing_sub_type property of a ScheduledQuery.
    #: This constant has a value of "NONE"
    SCHEDULED_QUERY_PROCESSING_SUB_TYPE_NONE = "NONE"

    #: A constant which can be used with the scheduled_query_retention_criteria property of a ScheduledQuery.
    #: This constant has a value of "KEEP_DATA_UNTIL_RETENTION_PERIOD"
    SCHEDULED_QUERY_RETENTION_CRITERIA_KEEP_DATA_UNTIL_RETENTION_PERIOD = "KEEP_DATA_UNTIL_RETENTION_PERIOD"

    #: A constant which can be used with the scheduled_query_retention_criteria property of a ScheduledQuery.
    #: This constant has a value of "UPDATE"
    SCHEDULED_QUERY_RETENTION_CRITERIA_UPDATE = "UPDATE"

    #: A constant which can be used with the lifecycle_state property of a ScheduledQuery.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ScheduledQuery.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ScheduledQuery.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ScheduledQuery.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ScheduledQuery.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ScheduledQuery.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduledQuery object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ScheduledQuery.
        :type id: str

        :param scheduled_query_processing_type:
            The value to assign to the scheduled_query_processing_type property of this ScheduledQuery.
            Allowed values for this property are: "EXPORT", "QUERY", "ALERT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type scheduled_query_processing_type: str

        :param scheduled_query_name:
            The value to assign to the scheduled_query_name property of this ScheduledQuery.
        :type scheduled_query_name: str

        :param scheduled_query_text:
            The value to assign to the scheduled_query_text property of this ScheduledQuery.
        :type scheduled_query_text: str

        :param scheduled_query_description:
            The value to assign to the scheduled_query_description property of this ScheduledQuery.
        :type scheduled_query_description: str

        :param scheduled_query_schedule:
            The value to assign to the scheduled_query_schedule property of this ScheduledQuery.
        :type scheduled_query_schedule: str

        :param scheduled_query_maximum_runtime_in_seconds:
            The value to assign to the scheduled_query_maximum_runtime_in_seconds property of this ScheduledQuery.
        :type scheduled_query_maximum_runtime_in_seconds: int

        :param scheduled_query_next_run_in_ms:
            The value to assign to the scheduled_query_next_run_in_ms property of this ScheduledQuery.
        :type scheduled_query_next_run_in_ms: int

        :param scheduled_query_retention_period_in_ms:
            The value to assign to the scheduled_query_retention_period_in_ms property of this ScheduledQuery.
        :type scheduled_query_retention_period_in_ms: int

        :param scheduled_query_processing_sub_type:
            The value to assign to the scheduled_query_processing_sub_type property of this ScheduledQuery.
            Allowed values for this property are: "OBJECT_STORAGE", "STREAMING", "CUSTOM_METRIC", "NONE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type scheduled_query_processing_sub_type: str

        :param scheduled_query_processing_configuration:
            The value to assign to the scheduled_query_processing_configuration property of this ScheduledQuery.
        :type scheduled_query_processing_configuration: oci.apm_traces.models.ScheduledQueryProcessingConfig

        :param scheduled_query_retention_criteria:
            The value to assign to the scheduled_query_retention_criteria property of this ScheduledQuery.
            Allowed values for this property are: "KEEP_DATA_UNTIL_RETENTION_PERIOD", "UPDATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type scheduled_query_retention_criteria: str

        :param scheduled_query_instances:
            The value to assign to the scheduled_query_instances property of this ScheduledQuery.
        :type scheduled_query_instances: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ScheduledQuery.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ScheduledQuery.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ScheduledQuery.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ScheduledQuery.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'scheduled_query_processing_type': 'str',
            'scheduled_query_name': 'str',
            'scheduled_query_text': 'str',
            'scheduled_query_description': 'str',
            'scheduled_query_schedule': 'str',
            'scheduled_query_maximum_runtime_in_seconds': 'int',
            'scheduled_query_next_run_in_ms': 'int',
            'scheduled_query_retention_period_in_ms': 'int',
            'scheduled_query_processing_sub_type': 'str',
            'scheduled_query_processing_configuration': 'ScheduledQueryProcessingConfig',
            'scheduled_query_retention_criteria': 'str',
            'scheduled_query_instances': 'str',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'scheduled_query_processing_type': 'scheduledQueryProcessingType',
            'scheduled_query_name': 'scheduledQueryName',
            'scheduled_query_text': 'scheduledQueryText',
            'scheduled_query_description': 'scheduledQueryDescription',
            'scheduled_query_schedule': 'scheduledQuerySchedule',
            'scheduled_query_maximum_runtime_in_seconds': 'scheduledQueryMaximumRuntimeInSeconds',
            'scheduled_query_next_run_in_ms': 'scheduledQueryNextRunInMs',
            'scheduled_query_retention_period_in_ms': 'scheduledQueryRetentionPeriodInMs',
            'scheduled_query_processing_sub_type': 'scheduledQueryProcessingSubType',
            'scheduled_query_processing_configuration': 'scheduledQueryProcessingConfiguration',
            'scheduled_query_retention_criteria': 'scheduledQueryRetentionCriteria',
            'scheduled_query_instances': 'scheduledQueryInstances',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._scheduled_query_processing_type = None
        self._scheduled_query_name = None
        self._scheduled_query_text = None
        self._scheduled_query_description = None
        self._scheduled_query_schedule = None
        self._scheduled_query_maximum_runtime_in_seconds = None
        self._scheduled_query_next_run_in_ms = None
        self._scheduled_query_retention_period_in_ms = None
        self._scheduled_query_processing_sub_type = None
        self._scheduled_query_processing_configuration = None
        self._scheduled_query_retention_criteria = None
        self._scheduled_query_instances = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        Gets the id of this ScheduledQuery.
        The `OCID`__ of the scheduled query . An OCID is generated
        when the scheduled query is created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this ScheduledQuery.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ScheduledQuery.
        The `OCID`__ of the scheduled query . An OCID is generated
        when the scheduled query is created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this ScheduledQuery.
        :type: str
        """
        self._id = id

    @property
    def scheduled_query_processing_type(self):
        """
        Gets the scheduled_query_processing_type of this ScheduledQuery.
        Processing type of the scheduled query.

        Allowed values for this property are: "EXPORT", "QUERY", "ALERT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The scheduled_query_processing_type of this ScheduledQuery.
        :rtype: str
        """
        return self._scheduled_query_processing_type

    @scheduled_query_processing_type.setter
    def scheduled_query_processing_type(self, scheduled_query_processing_type):
        """
        Sets the scheduled_query_processing_type of this ScheduledQuery.
        Processing type of the scheduled query.


        :param scheduled_query_processing_type: The scheduled_query_processing_type of this ScheduledQuery.
        :type: str
        """
        allowed_values = ["EXPORT", "QUERY", "ALERT"]
        if not value_allowed_none_or_none_sentinel(scheduled_query_processing_type, allowed_values):
            scheduled_query_processing_type = 'UNKNOWN_ENUM_VALUE'
        self._scheduled_query_processing_type = scheduled_query_processing_type

    @property
    def scheduled_query_name(self):
        """
        Gets the scheduled_query_name of this ScheduledQuery.
        Name of the scheduled query.


        :return: The scheduled_query_name of this ScheduledQuery.
        :rtype: str
        """
        return self._scheduled_query_name

    @scheduled_query_name.setter
    def scheduled_query_name(self, scheduled_query_name):
        """
        Sets the scheduled_query_name of this ScheduledQuery.
        Name of the scheduled query.


        :param scheduled_query_name: The scheduled_query_name of this ScheduledQuery.
        :type: str
        """
        self._scheduled_query_name = scheduled_query_name

    @property
    def scheduled_query_text(self):
        """
        Gets the scheduled_query_text of this ScheduledQuery.
        Scheduled query to be run.


        :return: The scheduled_query_text of this ScheduledQuery.
        :rtype: str
        """
        return self._scheduled_query_text

    @scheduled_query_text.setter
    def scheduled_query_text(self, scheduled_query_text):
        """
        Sets the scheduled_query_text of this ScheduledQuery.
        Scheduled query to be run.


        :param scheduled_query_text: The scheduled_query_text of this ScheduledQuery.
        :type: str
        """
        self._scheduled_query_text = scheduled_query_text

    @property
    def scheduled_query_description(self):
        """
        Gets the scheduled_query_description of this ScheduledQuery.
        Description for the scheduled query.


        :return: The scheduled_query_description of this ScheduledQuery.
        :rtype: str
        """
        return self._scheduled_query_description

    @scheduled_query_description.setter
    def scheduled_query_description(self, scheduled_query_description):
        """
        Sets the scheduled_query_description of this ScheduledQuery.
        Description for the scheduled query.


        :param scheduled_query_description: The scheduled_query_description of this ScheduledQuery.
        :type: str
        """
        self._scheduled_query_description = scheduled_query_description

    @property
    def scheduled_query_schedule(self):
        """
        Gets the scheduled_query_schedule of this ScheduledQuery.
        Schedule for the scheduled query.


        :return: The scheduled_query_schedule of this ScheduledQuery.
        :rtype: str
        """
        return self._scheduled_query_schedule

    @scheduled_query_schedule.setter
    def scheduled_query_schedule(self, scheduled_query_schedule):
        """
        Sets the scheduled_query_schedule of this ScheduledQuery.
        Schedule for the scheduled query.


        :param scheduled_query_schedule: The scheduled_query_schedule of this ScheduledQuery.
        :type: str
        """
        self._scheduled_query_schedule = scheduled_query_schedule

    @property
    def scheduled_query_maximum_runtime_in_seconds(self):
        """
        Gets the scheduled_query_maximum_runtime_in_seconds of this ScheduledQuery.
        Maximum runtime for the scheduled query in seconds.


        :return: The scheduled_query_maximum_runtime_in_seconds of this ScheduledQuery.
        :rtype: int
        """
        return self._scheduled_query_maximum_runtime_in_seconds

    @scheduled_query_maximum_runtime_in_seconds.setter
    def scheduled_query_maximum_runtime_in_seconds(self, scheduled_query_maximum_runtime_in_seconds):
        """
        Sets the scheduled_query_maximum_runtime_in_seconds of this ScheduledQuery.
        Maximum runtime for the scheduled query in seconds.


        :param scheduled_query_maximum_runtime_in_seconds: The scheduled_query_maximum_runtime_in_seconds of this ScheduledQuery.
        :type: int
        """
        self._scheduled_query_maximum_runtime_in_seconds = scheduled_query_maximum_runtime_in_seconds

    @property
    def scheduled_query_next_run_in_ms(self):
        """
        Gets the scheduled_query_next_run_in_ms of this ScheduledQuery.
        Next run for the scheduled query.


        :return: The scheduled_query_next_run_in_ms of this ScheduledQuery.
        :rtype: int
        """
        return self._scheduled_query_next_run_in_ms

    @scheduled_query_next_run_in_ms.setter
    def scheduled_query_next_run_in_ms(self, scheduled_query_next_run_in_ms):
        """
        Sets the scheduled_query_next_run_in_ms of this ScheduledQuery.
        Next run for the scheduled query.


        :param scheduled_query_next_run_in_ms: The scheduled_query_next_run_in_ms of this ScheduledQuery.
        :type: int
        """
        self._scheduled_query_next_run_in_ms = scheduled_query_next_run_in_ms

    @property
    def scheduled_query_retention_period_in_ms(self):
        """
        Gets the scheduled_query_retention_period_in_ms of this ScheduledQuery.
        Retention period for the scheduled query in milliseconds.


        :return: The scheduled_query_retention_period_in_ms of this ScheduledQuery.
        :rtype: int
        """
        return self._scheduled_query_retention_period_in_ms

    @scheduled_query_retention_period_in_ms.setter
    def scheduled_query_retention_period_in_ms(self, scheduled_query_retention_period_in_ms):
        """
        Sets the scheduled_query_retention_period_in_ms of this ScheduledQuery.
        Retention period for the scheduled query in milliseconds.


        :param scheduled_query_retention_period_in_ms: The scheduled_query_retention_period_in_ms of this ScheduledQuery.
        :type: int
        """
        self._scheduled_query_retention_period_in_ms = scheduled_query_retention_period_in_ms

    @property
    def scheduled_query_processing_sub_type(self):
        """
        Gets the scheduled_query_processing_sub_type of this ScheduledQuery.
        Processing sub type of the scheduled query.

        Allowed values for this property are: "OBJECT_STORAGE", "STREAMING", "CUSTOM_METRIC", "NONE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The scheduled_query_processing_sub_type of this ScheduledQuery.
        :rtype: str
        """
        return self._scheduled_query_processing_sub_type

    @scheduled_query_processing_sub_type.setter
    def scheduled_query_processing_sub_type(self, scheduled_query_processing_sub_type):
        """
        Sets the scheduled_query_processing_sub_type of this ScheduledQuery.
        Processing sub type of the scheduled query.


        :param scheduled_query_processing_sub_type: The scheduled_query_processing_sub_type of this ScheduledQuery.
        :type: str
        """
        allowed_values = ["OBJECT_STORAGE", "STREAMING", "CUSTOM_METRIC", "NONE"]
        if not value_allowed_none_or_none_sentinel(scheduled_query_processing_sub_type, allowed_values):
            scheduled_query_processing_sub_type = 'UNKNOWN_ENUM_VALUE'
        self._scheduled_query_processing_sub_type = scheduled_query_processing_sub_type

    @property
    def scheduled_query_processing_configuration(self):
        """
        Gets the scheduled_query_processing_configuration of this ScheduledQuery.

        :return: The scheduled_query_processing_configuration of this ScheduledQuery.
        :rtype: oci.apm_traces.models.ScheduledQueryProcessingConfig
        """
        return self._scheduled_query_processing_configuration

    @scheduled_query_processing_configuration.setter
    def scheduled_query_processing_configuration(self, scheduled_query_processing_configuration):
        """
        Sets the scheduled_query_processing_configuration of this ScheduledQuery.

        :param scheduled_query_processing_configuration: The scheduled_query_processing_configuration of this ScheduledQuery.
        :type: oci.apm_traces.models.ScheduledQueryProcessingConfig
        """
        self._scheduled_query_processing_configuration = scheduled_query_processing_configuration

    @property
    def scheduled_query_retention_criteria(self):
        """
        Gets the scheduled_query_retention_criteria of this ScheduledQuery.
        Retention criteria for the scheduled query.

        Allowed values for this property are: "KEEP_DATA_UNTIL_RETENTION_PERIOD", "UPDATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The scheduled_query_retention_criteria of this ScheduledQuery.
        :rtype: str
        """
        return self._scheduled_query_retention_criteria

    @scheduled_query_retention_criteria.setter
    def scheduled_query_retention_criteria(self, scheduled_query_retention_criteria):
        """
        Sets the scheduled_query_retention_criteria of this ScheduledQuery.
        Retention criteria for the scheduled query.


        :param scheduled_query_retention_criteria: The scheduled_query_retention_criteria of this ScheduledQuery.
        :type: str
        """
        allowed_values = ["KEEP_DATA_UNTIL_RETENTION_PERIOD", "UPDATE"]
        if not value_allowed_none_or_none_sentinel(scheduled_query_retention_criteria, allowed_values):
            scheduled_query_retention_criteria = 'UNKNOWN_ENUM_VALUE'
        self._scheduled_query_retention_criteria = scheduled_query_retention_criteria

    @property
    def scheduled_query_instances(self):
        """
        Gets the scheduled_query_instances of this ScheduledQuery.
        Scheduled query instances.


        :return: The scheduled_query_instances of this ScheduledQuery.
        :rtype: str
        """
        return self._scheduled_query_instances

    @scheduled_query_instances.setter
    def scheduled_query_instances(self, scheduled_query_instances):
        """
        Sets the scheduled_query_instances of this ScheduledQuery.
        Scheduled query instances.


        :param scheduled_query_instances: The scheduled_query_instances of this ScheduledQuery.
        :type: str
        """
        self._scheduled_query_instances = scheduled_query_instances

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ScheduledQuery.
        The current lifecycle state of the Scheduled Query.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ScheduledQuery.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ScheduledQuery.
        The current lifecycle state of the Scheduled Query.


        :param lifecycle_state: The lifecycle_state of this ScheduledQuery.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ScheduledQuery.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ScheduledQuery.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ScheduledQuery.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ScheduledQuery.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ScheduledQuery.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ScheduledQuery.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ScheduledQuery.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ScheduledQuery.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ScheduledQuery.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ScheduledQuery.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ScheduledQuery.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ScheduledQuery.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
