# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricBase(object):
    """
    MetricBase model.
    """

    #: A constant which can be used with the metric_source property of a MetricBase.
    #: This constant has a value of "COMPUTE_AGENT"
    METRIC_SOURCE_COMPUTE_AGENT = "COMPUTE_AGENT"

    #: A constant which can be used with the metric_source property of a MetricBase.
    #: This constant has a value of "CUSTOM_QUERY"
    METRIC_SOURCE_CUSTOM_QUERY = "CUSTOM_QUERY"

    def __init__(self, **kwargs):
        """
        Initializes a new MetricBase object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.autoscaling.models.CustomMetric`
        * :class:`~oci.autoscaling.models.Metric`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pending_duration:
            The value to assign to the pending_duration property of this MetricBase.
        :type pending_duration: str

        :param metric_source:
            The value to assign to the metric_source property of this MetricBase.
            Allowed values for this property are: "COMPUTE_AGENT", "CUSTOM_QUERY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type metric_source: str

        """
        self.swagger_types = {
            'pending_duration': 'str',
            'metric_source': 'str'
        }
        self.attribute_map = {
            'pending_duration': 'pendingDuration',
            'metric_source': 'metricSource'
        }
        self._pending_duration = None
        self._metric_source = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['metricSource']

        if type == 'CUSTOM_QUERY':
            return 'CustomMetric'

        if type == 'COMPUTE_AGENT':
            return 'Metric'
        else:
            return 'MetricBase'

    @property
    def pending_duration(self):
        """
        Gets the pending_duration of this MetricBase.
        The period of time that the condition defined in the alarm must persist before the alarm state
        changes from \"OK\" to \"FIRING\" or vice versa. For example, a value of 5 minutes means that the
        alarm must persist in breaching the condition for five minutes before the alarm updates its
        state to \"FIRING\"; likewise, the alarm must persist in not breaching the condition for five
        minutes before the alarm updates its state to \"OK.\"

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H`
        for one hour). Minimum: PT3M. Maximum: PT1H. Default: PT3M.


        :return: The pending_duration of this MetricBase.
        :rtype: str
        """
        return self._pending_duration

    @pending_duration.setter
    def pending_duration(self, pending_duration):
        """
        Sets the pending_duration of this MetricBase.
        The period of time that the condition defined in the alarm must persist before the alarm state
        changes from \"OK\" to \"FIRING\" or vice versa. For example, a value of 5 minutes means that the
        alarm must persist in breaching the condition for five minutes before the alarm updates its
        state to \"FIRING\"; likewise, the alarm must persist in not breaching the condition for five
        minutes before the alarm updates its state to \"OK.\"

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H`
        for one hour). Minimum: PT3M. Maximum: PT1H. Default: PT3M.


        :param pending_duration: The pending_duration of this MetricBase.
        :type: str
        """
        self._pending_duration = pending_duration

    @property
    def metric_source(self):
        """
        Gets the metric_source of this MetricBase.
        Source of the metric data for creating the alarm used to trigger autoscaling actions.

        The following values are supported:

        * `COMPUTE_AGENT`: CPU or memory metrics emitted by the Compute Instance Monitoring plugin.

        * `CUSTOM_QUERY`: A custom Monitoring Query Language (MQL) expression.

        Allowed values for this property are: "COMPUTE_AGENT", "CUSTOM_QUERY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The metric_source of this MetricBase.
        :rtype: str
        """
        return self._metric_source

    @metric_source.setter
    def metric_source(self, metric_source):
        """
        Sets the metric_source of this MetricBase.
        Source of the metric data for creating the alarm used to trigger autoscaling actions.

        The following values are supported:

        * `COMPUTE_AGENT`: CPU or memory metrics emitted by the Compute Instance Monitoring plugin.

        * `CUSTOM_QUERY`: A custom Monitoring Query Language (MQL) expression.


        :param metric_source: The metric_source of this MetricBase.
        :type: str
        """
        allowed_values = ["COMPUTE_AGENT", "CUSTOM_QUERY"]
        if not value_allowed_none_or_none_sentinel(metric_source, allowed_values):
            metric_source = 'UNKNOWN_ENUM_VALUE'
        self._metric_source = metric_source

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
