# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchTaskSummary(object):
    """
    Summary information about a batch task.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BatchTaskSummary object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.batch.models.ComputeTaskSummary`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BatchTaskSummary.
        :type id: str

        :param job_id:
            The value to assign to the job_id property of this BatchTaskSummary.
        :type job_id: str

        :param name:
            The value to assign to the name property of this BatchTaskSummary.
        :type name: str

        :param description:
            The value to assign to the description property of this BatchTaskSummary.
        :type description: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this BatchTaskSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this BatchTaskSummary.
        :type lifecycle_details: str

        :param type:
            The value to assign to the type property of this BatchTaskSummary.
        :type type: str

        """
        self.swagger_types = {
            'id': 'str',
            'job_id': 'str',
            'name': 'str',
            'description': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'job_id': 'jobId',
            'name': 'name',
            'description': 'description',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'type': 'type'
        }
        self._id = None
        self._job_id = None
        self._name = None
        self._description = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'COMPUTE':
            return 'ComputeTaskSummary'
        else:
            return 'BatchTaskSummary'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this BatchTaskSummary.
        The UUID of batch task.


        :return: The id of this BatchTaskSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BatchTaskSummary.
        The UUID of batch task.


        :param id: The id of this BatchTaskSummary.
        :type: str
        """
        self._id = id

    @property
    def job_id(self):
        """
        **[Required]** Gets the job_id of this BatchTaskSummary.
        The `OCID`__ of the batch job to which this task belongs.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The job_id of this BatchTaskSummary.
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """
        Sets the job_id of this BatchTaskSummary.
        The `OCID`__ of the batch job to which this task belongs.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param job_id: The job_id of this BatchTaskSummary.
        :type: str
        """
        self._job_id = job_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this BatchTaskSummary.
        The name of the batch task. It must be unique within its parent batch job.


        :return: The name of this BatchTaskSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this BatchTaskSummary.
        The name of the batch task. It must be unique within its parent batch job.


        :param name: The name of this BatchTaskSummary.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this BatchTaskSummary.
        An optional description that provides additional context next to the displayName.


        :return: The description of this BatchTaskSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BatchTaskSummary.
        An optional description that provides additional context next to the displayName.


        :param description: The description of this BatchTaskSummary.
        :type: str
        """
        self._description = description

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this BatchTaskSummary.
        The current state of the batch task.


        :return: The lifecycle_state of this BatchTaskSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this BatchTaskSummary.
        The current state of the batch task.


        :param lifecycle_state: The lifecycle_state of this BatchTaskSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this BatchTaskSummary.
        A message that describes the current state of the batch task in more detail. For example, can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this BatchTaskSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this BatchTaskSummary.
        A message that describes the current state of the batch task in more detail. For example, can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this BatchTaskSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def type(self):
        """
        **[Required]** Gets the type of this BatchTaskSummary.
        Type of the batch task. Also serves as a discriminator for sub-entities.


        :return: The type of this BatchTaskSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this BatchTaskSummary.
        Type of the batch task. Also serves as a discriminator for sub-entities.


        :param type: The type of this BatchTaskSummary.
        :type: str
        """
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
