# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031

from .batch_task_summary import BatchTaskSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeTaskSummary(BatchTaskSummary):
    """
    Summary information about a compute task.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeTaskSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.batch.models.ComputeTaskSummary.type` attribute
        of this class is ``COMPUTE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ComputeTaskSummary.
        :type id: str

        :param job_id:
            The value to assign to the job_id property of this ComputeTaskSummary.
        :type job_id: str

        :param name:
            The value to assign to the name property of this ComputeTaskSummary.
        :type name: str

        :param description:
            The value to assign to the description property of this ComputeTaskSummary.
        :type description: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComputeTaskSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ComputeTaskSummary.
        :type lifecycle_details: str

        :param type:
            The value to assign to the type property of this ComputeTaskSummary.
        :type type: str

        """
        self.swagger_types = {
            'id': 'str',
            'job_id': 'str',
            'name': 'str',
            'description': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'job_id': 'jobId',
            'name': 'name',
            'description': 'description',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'type': 'type'
        }
        self._id = None
        self._job_id = None
        self._name = None
        self._description = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._type = None
        self._type = 'COMPUTE'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
