# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBatchJobPoolDetails(object):
    """
    The data to create a batch job pool.
    If the value for a collection is absent or is explicitly provided as null, it will be converted to an empty value, i.e. \"[]\" or \"{}\" in json notation. This applies to nested collections as well.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBatchJobPoolDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateBatchJobPoolDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateBatchJobPoolDetails.
        :type compartment_id: str

        :param batch_context_id:
            The value to assign to the batch_context_id property of this CreateBatchJobPoolDetails.
        :type batch_context_id: str

        :param description:
            The value to assign to the description property of this CreateBatchJobPoolDetails.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateBatchJobPoolDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateBatchJobPoolDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'batch_context_id': 'str',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'batch_context_id': 'batchContextId',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._batch_context_id = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateBatchJobPoolDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchjobpool20250914115623.


        :return: The display_name of this CreateBatchJobPoolDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateBatchJobPoolDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchjobpool20250914115623.


        :param display_name: The display_name of this CreateBatchJobPoolDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateBatchJobPoolDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateBatchJobPoolDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateBatchJobPoolDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateBatchJobPoolDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def batch_context_id(self):
        """
        **[Required]** Gets the batch_context_id of this CreateBatchJobPoolDetails.
        The OCID of batch context.


        :return: The batch_context_id of this CreateBatchJobPoolDetails.
        :rtype: str
        """
        return self._batch_context_id

    @batch_context_id.setter
    def batch_context_id(self, batch_context_id):
        """
        Sets the batch_context_id of this CreateBatchJobPoolDetails.
        The OCID of batch context.


        :param batch_context_id: The batch_context_id of this CreateBatchJobPoolDetails.
        :type: str
        """
        self._batch_context_id = batch_context_id

    @property
    def description(self):
        """
        Gets the description of this CreateBatchJobPoolDetails.
        Summarized information about the batch job pool.


        :return: The description of this CreateBatchJobPoolDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateBatchJobPoolDetails.
        Summarized information about the batch job pool.


        :param description: The description of this CreateBatchJobPoolDetails.
        :type: str
        """
        self._description = description

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateBatchJobPoolDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateBatchJobPoolDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateBatchJobPoolDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateBatchJobPoolDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateBatchJobPoolDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateBatchJobPoolDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateBatchJobPoolDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateBatchJobPoolDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
