# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBatchTaskDetails(object):
    """
    A batch task contains common properties for all types of job tasks.
    """

    #: A constant which can be used with the type property of a CreateBatchTaskDetails.
    #: This constant has a value of "COMPUTE"
    TYPE_COMPUTE = "COMPUTE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBatchTaskDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.batch.models.CreateComputeTaskDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateBatchTaskDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateBatchTaskDetails.
        :type description: str

        :param type:
            The value to assign to the type property of this CreateBatchTaskDetails.
            Allowed values for this property are: "COMPUTE"
        :type type: str

        :param entitlement_claims:
            The value to assign to the entitlement_claims property of this CreateBatchTaskDetails.
        :type entitlement_claims: list[str]

        :param dependencies:
            The value to assign to the dependencies property of this CreateBatchTaskDetails.
        :type dependencies: list[str]

        :param environment_variables:
            The value to assign to the environment_variables property of this CreateBatchTaskDetails.
        :type environment_variables: list[oci.batch.models.EnvironmentVariable]

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'type': 'str',
            'entitlement_claims': 'list[str]',
            'dependencies': 'list[str]',
            'environment_variables': 'list[EnvironmentVariable]'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'type': 'type',
            'entitlement_claims': 'entitlementClaims',
            'dependencies': 'dependencies',
            'environment_variables': 'environmentVariables'
        }
        self._name = None
        self._description = None
        self._type = None
        self._entitlement_claims = None
        self._dependencies = None
        self._environment_variables = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'COMPUTE':
            return 'CreateComputeTaskDetails'
        else:
            return 'CreateBatchTaskDetails'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateBatchTaskDetails.
        The name of the batch task. It must be unique within its parent batch job.


        :return: The name of this CreateBatchTaskDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateBatchTaskDetails.
        The name of the batch task. It must be unique within its parent batch job.


        :param name: The name of this CreateBatchTaskDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CreateBatchTaskDetails.
        An optional description that provides additional context next to the displayName.


        :return: The description of this CreateBatchTaskDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateBatchTaskDetails.
        An optional description that provides additional context next to the displayName.


        :param description: The description of this CreateBatchTaskDetails.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateBatchTaskDetails.
        Type of the batch task. Also serves as a discriminator for sub-entities.

        Allowed values for this property are: "COMPUTE"


        :return: The type of this CreateBatchTaskDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateBatchTaskDetails.
        Type of the batch task. Also serves as a discriminator for sub-entities.


        :param type: The type of this CreateBatchTaskDetails.
        :type: str
        """
        allowed_values = ["COMPUTE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def entitlement_claims(self):
        """
        Gets the entitlement_claims of this CreateBatchTaskDetails.
        A list of resources (for example licences) this task needs for its execution.


        :return: The entitlement_claims of this CreateBatchTaskDetails.
        :rtype: list[str]
        """
        return self._entitlement_claims

    @entitlement_claims.setter
    def entitlement_claims(self, entitlement_claims):
        """
        Sets the entitlement_claims of this CreateBatchTaskDetails.
        A list of resources (for example licences) this task needs for its execution.


        :param entitlement_claims: The entitlement_claims of this CreateBatchTaskDetails.
        :type: list[str]
        """
        self._entitlement_claims = entitlement_claims

    @property
    def dependencies(self):
        """
        Gets the dependencies of this CreateBatchTaskDetails.
        A list of tasks from the same job this task depends on referenced by name.


        :return: The dependencies of this CreateBatchTaskDetails.
        :rtype: list[str]
        """
        return self._dependencies

    @dependencies.setter
    def dependencies(self, dependencies):
        """
        Sets the dependencies of this CreateBatchTaskDetails.
        A list of tasks from the same job this task depends on referenced by name.


        :param dependencies: The dependencies of this CreateBatchTaskDetails.
        :type: list[str]
        """
        self._dependencies = dependencies

    @property
    def environment_variables(self):
        """
        Gets the environment_variables of this CreateBatchTaskDetails.
        Environment variables to use for the task execution.


        :return: The environment_variables of this CreateBatchTaskDetails.
        :rtype: list[oci.batch.models.EnvironmentVariable]
        """
        return self._environment_variables

    @environment_variables.setter
    def environment_variables(self, environment_variables):
        """
        Sets the environment_variables of this CreateBatchTaskDetails.
        Environment variables to use for the task execution.


        :param environment_variables: The environment_variables of this CreateBatchTaskDetails.
        :type: list[oci.batch.models.EnvironmentVariable]
        """
        self._environment_variables = environment_variables

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
