# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031

from .fleet import Fleet
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceManagedFleet(Fleet):
    """
    Service managed Fleet configuration of the batch context.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceManagedFleet object with values from keyword arguments. The default value of the :py:attr:`~oci.batch.models.ServiceManagedFleet.type` attribute
        of this class is ``SERVICE_MANAGED_FLEET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ServiceManagedFleet.
            Allowed values for this property are: "SERVICE_MANAGED_FLEET"
        :type type: str

        :param name:
            The value to assign to the name property of this ServiceManagedFleet.
        :type name: str

        :param shape:
            The value to assign to the shape property of this ServiceManagedFleet.
        :type shape: oci.batch.models.FleetShape

        :param max_concurrent_tasks:
            The value to assign to the max_concurrent_tasks property of this ServiceManagedFleet.
        :type max_concurrent_tasks: int

        :param state:
            The value to assign to the state property of this ServiceManagedFleet.
        :type state: str

        :param details:
            The value to assign to the details property of this ServiceManagedFleet.
        :type details: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'shape': 'FleetShape',
            'max_concurrent_tasks': 'int',
            'state': 'str',
            'details': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'shape': 'shape',
            'max_concurrent_tasks': 'maxConcurrentTasks',
            'state': 'state',
            'details': 'details'
        }
        self._type = None
        self._name = None
        self._shape = None
        self._max_concurrent_tasks = None
        self._state = None
        self._details = None
        self._type = 'SERVICE_MANAGED_FLEET'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ServiceManagedFleet.
        Name of the service managed fleet.


        :return: The name of this ServiceManagedFleet.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ServiceManagedFleet.
        Name of the service managed fleet.


        :param name: The name of this ServiceManagedFleet.
        :type: str
        """
        self._name = name

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this ServiceManagedFleet.

        :return: The shape of this ServiceManagedFleet.
        :rtype: oci.batch.models.FleetShape
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ServiceManagedFleet.

        :param shape: The shape of this ServiceManagedFleet.
        :type: oci.batch.models.FleetShape
        """
        self._shape = shape

    @property
    def max_concurrent_tasks(self):
        """
        **[Required]** Gets the max_concurrent_tasks of this ServiceManagedFleet.
        Maximum number of concurrent tasks for the service managed fleet.


        :return: The max_concurrent_tasks of this ServiceManagedFleet.
        :rtype: int
        """
        return self._max_concurrent_tasks

    @max_concurrent_tasks.setter
    def max_concurrent_tasks(self, max_concurrent_tasks):
        """
        Sets the max_concurrent_tasks of this ServiceManagedFleet.
        Maximum number of concurrent tasks for the service managed fleet.


        :param max_concurrent_tasks: The max_concurrent_tasks of this ServiceManagedFleet.
        :type: int
        """
        self._max_concurrent_tasks = max_concurrent_tasks

    @property
    def state(self):
        """
        Gets the state of this ServiceManagedFleet.
        Current state of the service manage fleet configuration.


        :return: The state of this ServiceManagedFleet.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ServiceManagedFleet.
        Current state of the service manage fleet configuration.


        :param state: The state of this ServiceManagedFleet.
        :type: str
        """
        self._state = state

    @property
    def details(self):
        """
        Gets the details of this ServiceManagedFleet.
        A message that describes the current state of the service manage fleet configuration in more detail.


        :return: The details of this ServiceManagedFleet.
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this ServiceManagedFleet.
        A message that describes the current state of the service manage fleet configuration in more detail.


        :param details: The details of this ServiceManagedFleet.
        :type: str
        """
        self._details = details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
