# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BdsClusterVersionSummary(object):
    """
    Cluster version details including bds and odh version information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BdsClusterVersionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param bds_version:
            The value to assign to the bds_version property of this BdsClusterVersionSummary.
        :type bds_version: str

        :param odh_version:
            The value to assign to the odh_version property of this BdsClusterVersionSummary.
        :type odh_version: str

        """
        self.swagger_types = {
            'bds_version': 'str',
            'odh_version': 'str'
        }
        self.attribute_map = {
            'bds_version': 'bdsVersion',
            'odh_version': 'odhVersion'
        }
        self._bds_version = None
        self._odh_version = None

    @property
    def bds_version(self):
        """
        **[Required]** Gets the bds_version of this BdsClusterVersionSummary.
        BDS version to be used for cluster creation


        :return: The bds_version of this BdsClusterVersionSummary.
        :rtype: str
        """
        return self._bds_version

    @bds_version.setter
    def bds_version(self, bds_version):
        """
        Sets the bds_version of this BdsClusterVersionSummary.
        BDS version to be used for cluster creation


        :param bds_version: The bds_version of this BdsClusterVersionSummary.
        :type: str
        """
        self._bds_version = bds_version

    @property
    def odh_version(self):
        """
        Gets the odh_version of this BdsClusterVersionSummary.
        ODH version to be used for cluster creation


        :return: The odh_version of this BdsClusterVersionSummary.
        :rtype: str
        """
        return self._odh_version

    @odh_version.setter
    def odh_version(self, odh_version):
        """
        Sets the odh_version of this BdsClusterVersionSummary.
        ODH version to be used for cluster creation


        :param odh_version: The odh_version of this BdsClusterVersionSummary.
        :type: str
        """
        self._odh_version = odh_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
