# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCapacityReportShapeAvailabilityDetails(object):
    """
    Information about the shapes in a capacity report.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCapacityReportShapeAvailabilityDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param shape:
            The value to assign to the shape property of this CreateCapacityReportShapeAvailabilityDetails.
        :type shape: str

        :param shape_config:
            The value to assign to the shape_config property of this CreateCapacityReportShapeAvailabilityDetails.
        :type shape_config: oci.bds.models.ShapeConfigDetails

        """
        self.swagger_types = {
            'shape': 'str',
            'shape_config': 'ShapeConfigDetails'
        }
        self.attribute_map = {
            'shape': 'shape',
            'shape_config': 'shapeConfig'
        }
        self._shape = None
        self._shape_config = None

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this CreateCapacityReportShapeAvailabilityDetails.
        The shape that you want to request a capacity report for.


        :return: The shape of this CreateCapacityReportShapeAvailabilityDetails.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this CreateCapacityReportShapeAvailabilityDetails.
        The shape that you want to request a capacity report for.


        :param shape: The shape of this CreateCapacityReportShapeAvailabilityDetails.
        :type: str
        """
        self._shape = shape

    @property
    def shape_config(self):
        """
        Gets the shape_config of this CreateCapacityReportShapeAvailabilityDetails.

        :return: The shape_config of this CreateCapacityReportShapeAvailabilityDetails.
        :rtype: oci.bds.models.ShapeConfigDetails
        """
        return self._shape_config

    @shape_config.setter
    def shape_config(self, shape_config):
        """
        Sets the shape_config of this CreateCapacityReportShapeAvailabilityDetails.

        :param shape_config: The shape_config of this CreateCapacityReportShapeAvailabilityDetails.
        :type: oci.bds.models.ShapeConfigDetails
        """
        self._shape_config = shape_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
