# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DomainTypeCapacityReport(object):
    """
    Detailed information of the capacity under a domain.
    """

    #: A constant which can be used with the domain_type property of a DomainTypeCapacityReport.
    #: This constant has a value of "MULTI_AD"
    DOMAIN_TYPE_MULTI_AD = "MULTI_AD"

    #: A constant which can be used with the domain_type property of a DomainTypeCapacityReport.
    #: This constant has a value of "SINGLE_AD"
    DOMAIN_TYPE_SINGLE_AD = "SINGLE_AD"

    def __init__(self, **kwargs):
        """
        Initializes a new DomainTypeCapacityReport object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.bds.models.SingleAdCapacityReport`
        * :class:`~oci.bds.models.MultiAdCapacityReport`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param domain_type:
            The value to assign to the domain_type property of this DomainTypeCapacityReport.
            Allowed values for this property are: "MULTI_AD", "SINGLE_AD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type domain_type: str

        """
        self.swagger_types = {
            'domain_type': 'str'
        }
        self.attribute_map = {
            'domain_type': 'domainType'
        }
        self._domain_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['domainType']

        if type == 'SINGLE_AD':
            return 'SingleAdCapacityReport'

        if type == 'MULTI_AD':
            return 'MultiAdCapacityReport'
        else:
            return 'DomainTypeCapacityReport'

    @property
    def domain_type(self):
        """
        **[Required]** Gets the domain_type of this DomainTypeCapacityReport.
        Type of domain level for the capacity report.

        Allowed values for this property are: "MULTI_AD", "SINGLE_AD", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The domain_type of this DomainTypeCapacityReport.
        :rtype: str
        """
        return self._domain_type

    @domain_type.setter
    def domain_type(self, domain_type):
        """
        Sets the domain_type of this DomainTypeCapacityReport.
        Type of domain level for the capacity report.


        :param domain_type: The domain_type of this DomainTypeCapacityReport.
        :type: str
        """
        allowed_values = ["MULTI_AD", "SINGLE_AD"]
        if not value_allowed_none_or_none_sentinel(domain_type, allowed_values):
            domain_type = 'UNKNOWN_ENUM_VALUE'
        self._domain_type = domain_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
