# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OsPatchSummary(object):
    """
    Summary of an available os patch to a cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OsPatchSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param os_patch_version:
            The value to assign to the os_patch_version property of this OsPatchSummary.
        :type os_patch_version: str

        :param release_date:
            The value to assign to the release_date property of this OsPatchSummary.
        :type release_date: datetime

        """
        self.swagger_types = {
            'os_patch_version': 'str',
            'release_date': 'datetime'
        }
        self.attribute_map = {
            'os_patch_version': 'osPatchVersion',
            'release_date': 'releaseDate'
        }
        self._os_patch_version = None
        self._release_date = None

    @property
    def os_patch_version(self):
        """
        **[Required]** Gets the os_patch_version of this OsPatchSummary.
        Patch version of the os patch.


        :return: The os_patch_version of this OsPatchSummary.
        :rtype: str
        """
        return self._os_patch_version

    @os_patch_version.setter
    def os_patch_version(self, os_patch_version):
        """
        Sets the os_patch_version of this OsPatchSummary.
        Patch version of the os patch.


        :param os_patch_version: The os_patch_version of this OsPatchSummary.
        :type: str
        """
        self._os_patch_version = os_patch_version

    @property
    def release_date(self):
        """
        **[Required]** Gets the release_date of this OsPatchSummary.
        The time when the OS patch was released.


        :return: The release_date of this OsPatchSummary.
        :rtype: datetime
        """
        return self._release_date

    @release_date.setter
    def release_date(self, release_date):
        """
        Sets the release_date of this OsPatchSummary.
        The time when the OS patch was released.


        :param release_date: The release_date of this OsPatchSummary.
        :type: datetime
        """
        self._release_date = release_date

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
