# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CostAlertSubscription(object):
    """
    A CostAlertSubscription.
    """

    #: A constant which can be used with the lifecycle_state property of a CostAlertSubscription.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CostAlertSubscription.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new CostAlertSubscription object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CostAlertSubscription.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CostAlertSubscription.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this CostAlertSubscription.
        :type name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CostAlertSubscription.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param channels:
            The value to assign to the channels property of this CostAlertSubscription.
        :type channels: str

        :param description:
            The value to assign to the description property of this CostAlertSubscription.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this CostAlertSubscription.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CostAlertSubscription.
        :type time_updated: datetime

        :param cost_anomaly_monitors:
            The value to assign to the cost_anomaly_monitors property of this CostAlertSubscription.
        :type cost_anomaly_monitors: object

        :param defined_tags:
            The value to assign to the defined_tags property of this CostAlertSubscription.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CostAlertSubscription.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this CostAlertSubscription.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'name': 'str',
            'lifecycle_state': 'str',
            'channels': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'cost_anomaly_monitors': 'object',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'name': 'name',
            'lifecycle_state': 'lifecycleState',
            'channels': 'channels',
            'description': 'description',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'cost_anomaly_monitors': 'costAnomalyMonitors',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._name = None
        self._lifecycle_state = None
        self._channels = None
        self._description = None
        self._time_created = None
        self._time_updated = None
        self._cost_anomaly_monitors = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CostAlertSubscription.
        The OCID of the Cost Alert Subscription.


        :return: The id of this CostAlertSubscription.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CostAlertSubscription.
        The OCID of the Cost Alert Subscription.


        :param id: The id of this CostAlertSubscription.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CostAlertSubscription.
        The OCID of the compartment which hold the cost alert subscription resource.


        :return: The compartment_id of this CostAlertSubscription.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CostAlertSubscription.
        The OCID of the compartment which hold the cost alert subscription resource.


        :param compartment_id: The compartment_id of this CostAlertSubscription.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CostAlertSubscription.
        The name of the cost alert subscription. Avoid entering confidential information.


        :return: The name of this CostAlertSubscription.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CostAlertSubscription.
        The name of the cost alert subscription. Avoid entering confidential information.


        :param name: The name of this CostAlertSubscription.
        :type: str
        """
        self._name = name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CostAlertSubscription.
        The current state of the cost alert subscription.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this CostAlertSubscription.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CostAlertSubscription.
        The current state of the cost alert subscription.


        :param lifecycle_state: The lifecycle_state of this CostAlertSubscription.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def channels(self):
        """
        **[Required]** Gets the channels of this CostAlertSubscription.
        The notification channels string.


        :return: The channels of this CostAlertSubscription.
        :rtype: str
        """
        return self._channels

    @channels.setter
    def channels(self, channels):
        """
        Sets the channels of this CostAlertSubscription.
        The notification channels string.


        :param channels: The channels of this CostAlertSubscription.
        :type: str
        """
        self._channels = channels

    @property
    def description(self):
        """
        Gets the description of this CostAlertSubscription.
        The description of the cost alert subscription.


        :return: The description of this CostAlertSubscription.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CostAlertSubscription.
        The description of the cost alert subscription.


        :param description: The description of this CostAlertSubscription.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CostAlertSubscription.
        The time that the cost alert subscription was created.


        :return: The time_created of this CostAlertSubscription.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CostAlertSubscription.
        The time that the cost alert subscription was created.


        :param time_created: The time_created of this CostAlertSubscription.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CostAlertSubscription.
        The time that the cost alert subscription was updated.


        :return: The time_updated of this CostAlertSubscription.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CostAlertSubscription.
        The time that the cost alert subscription was updated.


        :param time_updated: The time_updated of this CostAlertSubscription.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def cost_anomaly_monitors(self):
        """
        **[Required]** Gets the cost_anomaly_monitors of this CostAlertSubscription.
        List of monitor identifiers


        :return: The cost_anomaly_monitors of this CostAlertSubscription.
        :rtype: object
        """
        return self._cost_anomaly_monitors

    @cost_anomaly_monitors.setter
    def cost_anomaly_monitors(self, cost_anomaly_monitors):
        """
        Sets the cost_anomaly_monitors of this CostAlertSubscription.
        List of monitor identifiers


        :param cost_anomaly_monitors: The cost_anomaly_monitors of this CostAlertSubscription.
        :type: object
        """
        self._cost_anomaly_monitors = cost_anomaly_monitors

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CostAlertSubscription.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CostAlertSubscription.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CostAlertSubscription.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CostAlertSubscription.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CostAlertSubscription.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CostAlertSubscription.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CostAlertSubscription.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CostAlertSubscription.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CostAlertSubscription.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this CostAlertSubscription.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CostAlertSubscription.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this CostAlertSubscription.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
