# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ClusterPlacementGroup(object):
    """
    A cluster placement group, which is a logical grouping of resources that offer low latency within an availability domain by being placed in close physical proximity.
    """

    #: A constant which can be used with the cluster_placement_group_type property of a ClusterPlacementGroup.
    #: This constant has a value of "STANDARD"
    CLUSTER_PLACEMENT_GROUP_TYPE_STANDARD = "STANDARD"

    #: A constant which can be used with the lifecycle_state property of a ClusterPlacementGroup.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ClusterPlacementGroup.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ClusterPlacementGroup.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ClusterPlacementGroup.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ClusterPlacementGroup.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ClusterPlacementGroup.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ClusterPlacementGroup.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ClusterPlacementGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ClusterPlacementGroup.
        :type id: str

        :param name:
            The value to assign to the name property of this ClusterPlacementGroup.
        :type name: str

        :param description:
            The value to assign to the description property of this ClusterPlacementGroup.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ClusterPlacementGroup.
        :type compartment_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this ClusterPlacementGroup.
        :type availability_domain: str

        :param cluster_placement_group_type:
            The value to assign to the cluster_placement_group_type property of this ClusterPlacementGroup.
            Allowed values for this property are: "STANDARD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cluster_placement_group_type: str

        :param time_created:
            The value to assign to the time_created property of this ClusterPlacementGroup.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ClusterPlacementGroup.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ClusterPlacementGroup.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ClusterPlacementGroup.
        :type lifecycle_details: str

        :param placement_instruction:
            The value to assign to the placement_instruction property of this ClusterPlacementGroup.
        :type placement_instruction: oci.cluster_placement_groups.models.PlacementInstructionDetails

        :param capabilities:
            The value to assign to the capabilities property of this ClusterPlacementGroup.
        :type capabilities: oci.cluster_placement_groups.models.CapabilitiesCollection

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ClusterPlacementGroup.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ClusterPlacementGroup.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ClusterPlacementGroup.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'availability_domain': 'str',
            'cluster_placement_group_type': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'placement_instruction': 'PlacementInstructionDetails',
            'capabilities': 'CapabilitiesCollection',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'availability_domain': 'availabilityDomain',
            'cluster_placement_group_type': 'clusterPlacementGroupType',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'placement_instruction': 'placementInstruction',
            'capabilities': 'capabilities',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._name = None
        self._description = None
        self._compartment_id = None
        self._availability_domain = None
        self._cluster_placement_group_type = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._placement_instruction = None
        self._capabilities = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ClusterPlacementGroup.
        The `OCID`__ of the cluster placement group.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ClusterPlacementGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ClusterPlacementGroup.
        The `OCID`__ of the cluster placement group.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ClusterPlacementGroup.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ClusterPlacementGroup.
        The user-friendly name of the cluster placement group. The display name for a cluster placement must be unique and you cannot change it. Avoid entering confidential information.


        :return: The name of this ClusterPlacementGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ClusterPlacementGroup.
        The user-friendly name of the cluster placement group. The display name for a cluster placement must be unique and you cannot change it. Avoid entering confidential information.


        :param name: The name of this ClusterPlacementGroup.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this ClusterPlacementGroup.
        A description of the cluster placement group.


        :return: The description of this ClusterPlacementGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ClusterPlacementGroup.
        A description of the cluster placement group.


        :param description: The description of this ClusterPlacementGroup.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ClusterPlacementGroup.
        The `OCID`__ of the compartment that contains the cluster placement group.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ClusterPlacementGroup.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ClusterPlacementGroup.
        The `OCID`__ of the compartment that contains the cluster placement group.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ClusterPlacementGroup.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this ClusterPlacementGroup.
        The availability domain of the cluster placement group.


        :return: The availability_domain of this ClusterPlacementGroup.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this ClusterPlacementGroup.
        The availability domain of the cluster placement group.


        :param availability_domain: The availability_domain of this ClusterPlacementGroup.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def cluster_placement_group_type(self):
        """
        **[Required]** Gets the cluster_placement_group_type of this ClusterPlacementGroup.
        The type of cluster placement group.

        Allowed values for this property are: "STANDARD", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cluster_placement_group_type of this ClusterPlacementGroup.
        :rtype: str
        """
        return self._cluster_placement_group_type

    @cluster_placement_group_type.setter
    def cluster_placement_group_type(self, cluster_placement_group_type):
        """
        Sets the cluster_placement_group_type of this ClusterPlacementGroup.
        The type of cluster placement group.


        :param cluster_placement_group_type: The cluster_placement_group_type of this ClusterPlacementGroup.
        :type: str
        """
        allowed_values = ["STANDARD"]
        if not value_allowed_none_or_none_sentinel(cluster_placement_group_type, allowed_values):
            cluster_placement_group_type = 'UNKNOWN_ENUM_VALUE'
        self._cluster_placement_group_type = cluster_placement_group_type

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ClusterPlacementGroup.
        The time the cluster placement group was created, expressed in `RFC 3339`__ timestamp format.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ClusterPlacementGroup.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ClusterPlacementGroup.
        The time the cluster placement group was created, expressed in `RFC 3339`__ timestamp format.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ClusterPlacementGroup.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ClusterPlacementGroup.
        The time the cluster placement group was updated, expressed in `RFC 3339`__ timestamp format.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ClusterPlacementGroup.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ClusterPlacementGroup.
        The time the cluster placement group was updated, expressed in `RFC 3339`__ timestamp format.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ClusterPlacementGroup.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ClusterPlacementGroup.
        The current state of the ClusterPlacementGroup.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ClusterPlacementGroup.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ClusterPlacementGroup.
        The current state of the ClusterPlacementGroup.


        :param lifecycle_state: The lifecycle_state of this ClusterPlacementGroup.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ClusterPlacementGroup.
        A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.


        :return: The lifecycle_details of this ClusterPlacementGroup.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ClusterPlacementGroup.
        A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.


        :param lifecycle_details: The lifecycle_details of this ClusterPlacementGroup.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def placement_instruction(self):
        """
        Gets the placement_instruction of this ClusterPlacementGroup.

        :return: The placement_instruction of this ClusterPlacementGroup.
        :rtype: oci.cluster_placement_groups.models.PlacementInstructionDetails
        """
        return self._placement_instruction

    @placement_instruction.setter
    def placement_instruction(self, placement_instruction):
        """
        Sets the placement_instruction of this ClusterPlacementGroup.

        :param placement_instruction: The placement_instruction of this ClusterPlacementGroup.
        :type: oci.cluster_placement_groups.models.PlacementInstructionDetails
        """
        self._placement_instruction = placement_instruction

    @property
    def capabilities(self):
        """
        Gets the capabilities of this ClusterPlacementGroup.

        :return: The capabilities of this ClusterPlacementGroup.
        :rtype: oci.cluster_placement_groups.models.CapabilitiesCollection
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """
        Sets the capabilities of this ClusterPlacementGroup.

        :param capabilities: The capabilities of this ClusterPlacementGroup.
        :type: oci.cluster_placement_groups.models.CapabilitiesCollection
        """
        self._capabilities = capabilities

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ClusterPlacementGroup.
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ClusterPlacementGroup.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ClusterPlacementGroup.
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ClusterPlacementGroup.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ClusterPlacementGroup.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ClusterPlacementGroup.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ClusterPlacementGroup.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ClusterPlacementGroup.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ClusterPlacementGroup.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ClusterPlacementGroup.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ClusterPlacementGroup.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ClusterPlacementGroup.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
