# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221208


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CccInfrastructureSummary(object):
    """
    Summary information about a Compute Cloud@Customer infrastructure.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CccInfrastructureSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CccInfrastructureSummary.
        :type id: str

        :param short_name:
            The value to assign to the short_name property of this CccInfrastructureSummary.
        :type short_name: str

        :param display_name:
            The value to assign to the display_name property of this CccInfrastructureSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CccInfrastructureSummary.
        :type compartment_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CccInfrastructureSummary.
        :type subnet_id: str

        :param time_created:
            The value to assign to the time_created property of this CccInfrastructureSummary.
        :type time_created: datetime

        :param connection_state:
            The value to assign to the connection_state property of this CccInfrastructureSummary.
        :type connection_state: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CccInfrastructureSummary.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CccInfrastructureSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CccInfrastructureSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CccInfrastructureSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'short_name': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'subnet_id': 'str',
            'time_created': 'datetime',
            'connection_state': 'str',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'short_name': 'shortName',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'subnet_id': 'subnetId',
            'time_created': 'timeCreated',
            'connection_state': 'connectionState',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._short_name = None
        self._display_name = None
        self._compartment_id = None
        self._subnet_id = None
        self._time_created = None
        self._connection_state = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CccInfrastructureSummary.
        The Compute Cloud@Customer infrastructure
        `OCID`__.
        This cannot be changed once created.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this CccInfrastructureSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CccInfrastructureSummary.
        The Compute Cloud@Customer infrastructure
        `OCID`__.
        This cannot be changed once created.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this CccInfrastructureSummary.
        :type: str
        """
        self._id = id

    @property
    def short_name(self):
        """
        Gets the short_name of this CccInfrastructureSummary.
        The Compute Cloud@Customer infrastructure short name. This is generated at
        the time the resource is created and cannot be changed. The short name can be
        used when communicating with Oracle Service and may be used during the configuration
        of the data center network.


        :return: The short_name of this CccInfrastructureSummary.
        :rtype: str
        """
        return self._short_name

    @short_name.setter
    def short_name(self, short_name):
        """
        Sets the short_name of this CccInfrastructureSummary.
        The Compute Cloud@Customer infrastructure short name. This is generated at
        the time the resource is created and cannot be changed. The short name can be
        used when communicating with Oracle Service and may be used during the configuration
        of the data center network.


        :param short_name: The short_name of this CccInfrastructureSummary.
        :type: str
        """
        self._short_name = short_name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CccInfrastructureSummary.
        The name that will be used to display the Compute Cloud@Customer infrastructure
        in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed.
        Avoid entering confidential information.


        :return: The display_name of this CccInfrastructureSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CccInfrastructureSummary.
        The name that will be used to display the Compute Cloud@Customer infrastructure
        in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed.
        Avoid entering confidential information.


        :param display_name: The display_name of this CccInfrastructureSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CccInfrastructureSummary.
        The compartment `OCID`__ associated with
        the infrastructure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CccInfrastructureSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CccInfrastructureSummary.
        The compartment `OCID`__ associated with
        the infrastructure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CccInfrastructureSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CccInfrastructureSummary.
        `OCID`__ for the network subnet that is
        used to communicate with Compute Cloud@Customer infrastructure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CccInfrastructureSummary.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CccInfrastructureSummary.
        `OCID`__ for the network subnet that is
        used to communicate with Compute Cloud@Customer infrastructure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CccInfrastructureSummary.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CccInfrastructureSummary.
        Compute Cloud@Customer infrastructure creation date and time. An RFC3339 formatted
        datetime string.


        :return: The time_created of this CccInfrastructureSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CccInfrastructureSummary.
        Compute Cloud@Customer infrastructure creation date and time. An RFC3339 formatted
        datetime string.


        :param time_created: The time_created of this CccInfrastructureSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def connection_state(self):
        """
        Gets the connection_state of this CccInfrastructureSummary.
        The current connection state of the infrastructure.


        :return: The connection_state of this CccInfrastructureSummary.
        :rtype: str
        """
        return self._connection_state

    @connection_state.setter
    def connection_state(self, connection_state):
        """
        Sets the connection_state of this CccInfrastructureSummary.
        The current connection state of the infrastructure.


        :param connection_state: The connection_state of this CccInfrastructureSummary.
        :type: str
        """
        self._connection_state = connection_state

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CccInfrastructureSummary.
        The current state of the Compute Cloud@Customer infrastructure.


        :return: The lifecycle_state of this CccInfrastructureSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CccInfrastructureSummary.
        The current state of the Compute Cloud@Customer infrastructure.


        :param lifecycle_state: The lifecycle_state of this CccInfrastructureSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CccInfrastructureSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CccInfrastructureSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CccInfrastructureSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CccInfrastructureSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CccInfrastructureSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CccInfrastructureSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CccInfrastructureSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CccInfrastructureSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CccInfrastructureSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CccInfrastructureSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CccInfrastructureSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CccInfrastructureSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
