# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddIpv4SubnetCidrDetails(object):
    """
    Details used when adding an IPv4 prefix to a subnet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AddIpv4SubnetCidrDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ipv4_cidr_block:
            The value to assign to the ipv4_cidr_block property of this AddIpv4SubnetCidrDetails.
        :type ipv4_cidr_block: str

        """
        self.swagger_types = {
            'ipv4_cidr_block': 'str'
        }
        self.attribute_map = {
            'ipv4_cidr_block': 'ipv4CidrBlock'
        }
        self._ipv4_cidr_block = None

    @property
    def ipv4_cidr_block(self):
        """
        **[Required]** Gets the ipv4_cidr_block of this AddIpv4SubnetCidrDetails.
        The CIDR IP address range of the subnet. The CIDR must maintain the following rules -

        a. The CIDR block is valid and correctly formatted.
        b. The new range is within one of the parent VCN ranges.

        Example: `10.0.1.0/24`


        :return: The ipv4_cidr_block of this AddIpv4SubnetCidrDetails.
        :rtype: str
        """
        return self._ipv4_cidr_block

    @ipv4_cidr_block.setter
    def ipv4_cidr_block(self, ipv4_cidr_block):
        """
        Sets the ipv4_cidr_block of this AddIpv4SubnetCidrDetails.
        The CIDR IP address range of the subnet. The CIDR must maintain the following rules -

        a. The CIDR block is valid and correctly formatted.
        b. The new range is within one of the parent VCN ranges.

        Example: `10.0.1.0/24`


        :param ipv4_cidr_block: The ipv4_cidr_block of this AddIpv4SubnetCidrDetails.
        :type: str
        """
        self._ipv4_cidr_block = ipv4_cidr_block

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
