# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttachComputeHostGroupHostDetails(object):
    """
    Specifies the host group id
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AttachComputeHostGroupHostDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compute_host_group_id:
            The value to assign to the compute_host_group_id property of this AttachComputeHostGroupHostDetails.
        :type compute_host_group_id: str

        """
        self.swagger_types = {
            'compute_host_group_id': 'str'
        }
        self.attribute_map = {
            'compute_host_group_id': 'computeHostGroupId'
        }
        self._compute_host_group_id = None

    @property
    def compute_host_group_id(self):
        """
        **[Required]** Gets the compute_host_group_id of this AttachComputeHostGroupHostDetails.
        'The `OCID`__ of the compute host group.'

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_host_group_id of this AttachComputeHostGroupHostDetails.
        :rtype: str
        """
        return self._compute_host_group_id

    @compute_host_group_id.setter
    def compute_host_group_id(self, compute_host_group_id):
        """
        Sets the compute_host_group_id of this AttachComputeHostGroupHostDetails.
        'The `OCID`__ of the compute host group.'

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_host_group_id: The compute_host_group_id of this AttachComputeHostGroupHostDetails.
        :type: str
        """
        self._compute_host_group_id = compute_host_group_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
