# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComponentVersion(object):
    """
    Represents a specific component type and its associated firmware versions.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComponentVersion object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_type:
            The value to assign to the component_type property of this ComponentVersion.
        :type component_type: str

        :param version:
            The value to assign to the version property of this ComponentVersion.
        :type version: list[str]

        """
        self.swagger_types = {
            'component_type': 'str',
            'version': 'list[str]'
        }
        self.attribute_map = {
            'component_type': 'componentType',
            'version': 'version'
        }
        self._component_type = None
        self._version = None

    @property
    def component_type(self):
        """
        **[Required]** Gets the component_type of this ComponentVersion.
        The type of component.


        :return: The component_type of this ComponentVersion.
        :rtype: str
        """
        return self._component_type

    @component_type.setter
    def component_type(self, component_type):
        """
        Sets the component_type of this ComponentVersion.
        The type of component.


        :param component_type: The component_type of this ComponentVersion.
        :type: str
        """
        self._component_type = component_type

    @property
    def version(self):
        """
        **[Required]** Gets the version of this ComponentVersion.
        A list of firmware versions associated with this component type.


        :return: The version of this ComponentVersion.
        :rtype: list[str]
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ComponentVersion.
        A list of firmware versions associated with this component type.


        :param version: The version of this ComponentVersion.
        :type: list[str]
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
