# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeGpuMemoryClusterInstanceSummary(object):
    """
    The customer facing GPU memory cluster instance object details.
    """

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "MOVING"
    LIFECYCLE_STATE_MOVING = "MOVING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "RUNNING"
    LIFECYCLE_STATE_RUNNING = "RUNNING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "STARTING"
    LIFECYCLE_STATE_STARTING = "STARTING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "STOPPING"
    LIFECYCLE_STATE_STOPPING = "STOPPING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "STOPPED"
    LIFECYCLE_STATE_STOPPED = "STOPPED"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "SUSPENDING"
    LIFECYCLE_STATE_SUSPENDING = "SUSPENDING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "SUSPENDED"
    LIFECYCLE_STATE_SUSPENDED = "SUSPENDED"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "CREATING_IMAGE"
    LIFECYCLE_STATE_CREATING_IMAGE = "CREATING_IMAGE"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a ComputeGpuMemoryClusterInstanceSummary.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeGpuMemoryClusterInstanceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this ComputeGpuMemoryClusterInstanceSummary.
        :type availability_domain: str

        :param id:
            The value to assign to the id property of this ComputeGpuMemoryClusterInstanceSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ComputeGpuMemoryClusterInstanceSummary.
        :type compartment_id: str

        :param fault_domain:
            The value to assign to the fault_domain property of this ComputeGpuMemoryClusterInstanceSummary.
        :type fault_domain: str

        :param instance_configuration_id:
            The value to assign to the instance_configuration_id property of this ComputeGpuMemoryClusterInstanceSummary.
        :type instance_configuration_id: str

        :param region:
            The value to assign to the region property of this ComputeGpuMemoryClusterInstanceSummary.
        :type region: str

        :param instance_shape:
            The value to assign to the instance_shape property of this ComputeGpuMemoryClusterInstanceSummary.
        :type instance_shape: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComputeGpuMemoryClusterInstanceSummary.
            Allowed values for this property are: "MOVING", "PROVISIONING", "RUNNING", "STARTING", "STOPPING", "STOPPED", "SUSPENDING", "SUSPENDED", "CREATING_IMAGE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param display_name:
            The value to assign to the display_name property of this ComputeGpuMemoryClusterInstanceSummary.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this ComputeGpuMemoryClusterInstanceSummary.
        :type time_created: datetime

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'fault_domain': 'str',
            'instance_configuration_id': 'str',
            'region': 'str',
            'instance_shape': 'str',
            'lifecycle_state': 'str',
            'display_name': 'str',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'fault_domain': 'faultDomain',
            'instance_configuration_id': 'instanceConfigurationId',
            'region': 'region',
            'instance_shape': 'instanceShape',
            'lifecycle_state': 'lifecycleState',
            'display_name': 'displayName',
            'time_created': 'timeCreated'
        }
        self._availability_domain = None
        self._id = None
        self._compartment_id = None
        self._fault_domain = None
        self._instance_configuration_id = None
        self._region = None
        self._instance_shape = None
        self._lifecycle_state = None
        self._display_name = None
        self._time_created = None

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this ComputeGpuMemoryClusterInstanceSummary.
        The availability domain of the GPU memory cluster instance.


        :return: The availability_domain of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this ComputeGpuMemoryClusterInstanceSummary.
        The availability domain of the GPU memory cluster instance.


        :param availability_domain: The availability_domain of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def id(self):
        """
        Gets the id of this ComputeGpuMemoryClusterInstanceSummary.
        The `OCID`__ for the Customer-unique GPU memory cluster instance

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComputeGpuMemoryClusterInstanceSummary.
        The `OCID`__ for the Customer-unique GPU memory cluster instance

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this ComputeGpuMemoryClusterInstanceSummary.
        The `OCID`__ for the compartment
        compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ComputeGpuMemoryClusterInstanceSummary.
        The `OCID`__ for the compartment
        compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this ComputeGpuMemoryClusterInstanceSummary.
        The fault domain the GPU memory cluster instance is running in.


        :return: The fault_domain of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this ComputeGpuMemoryClusterInstanceSummary.
        The fault domain the GPU memory cluster instance is running in.


        :param fault_domain: The fault_domain of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def instance_configuration_id(self):
        """
        Gets the instance_configuration_id of this ComputeGpuMemoryClusterInstanceSummary.
        Configuration to be used for this GPU Memory Cluster instance.


        :return: The instance_configuration_id of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._instance_configuration_id

    @instance_configuration_id.setter
    def instance_configuration_id(self, instance_configuration_id):
        """
        Sets the instance_configuration_id of this ComputeGpuMemoryClusterInstanceSummary.
        Configuration to be used for this GPU Memory Cluster instance.


        :param instance_configuration_id: The instance_configuration_id of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        self._instance_configuration_id = instance_configuration_id

    @property
    def region(self):
        """
        Gets the region of this ComputeGpuMemoryClusterInstanceSummary.
        The region that contains the availability domain the instance is running in.


        :return: The region of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this ComputeGpuMemoryClusterInstanceSummary.
        The region that contains the availability domain the instance is running in.


        :param region: The region of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        self._region = region

    @property
    def instance_shape(self):
        """
        Gets the instance_shape of this ComputeGpuMemoryClusterInstanceSummary.
        The shape of an instance. The shape determines the number of CPUs, amount of memory,
        and other resources allocated to the instance. The shape determines the number of CPUs,
        the amount of memory, and other resources allocated to the instance.
        You can list all available shapes by calling :func:`list_shapes`.


        :return: The instance_shape of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._instance_shape

    @instance_shape.setter
    def instance_shape(self, instance_shape):
        """
        Sets the instance_shape of this ComputeGpuMemoryClusterInstanceSummary.
        The shape of an instance. The shape determines the number of CPUs, amount of memory,
        and other resources allocated to the instance. The shape determines the number of CPUs,
        the amount of memory, and other resources allocated to the instance.
        You can list all available shapes by calling :func:`list_shapes`.


        :param instance_shape: The instance_shape of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        self._instance_shape = instance_shape

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ComputeGpuMemoryClusterInstanceSummary.
        The lifecycle state of the GPU memory cluster instance

        Allowed values for this property are: "MOVING", "PROVISIONING", "RUNNING", "STARTING", "STOPPING", "STOPPED", "SUSPENDING", "SUSPENDED", "CREATING_IMAGE", "TERMINATING", "TERMINATED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ComputeGpuMemoryClusterInstanceSummary.
        The lifecycle state of the GPU memory cluster instance


        :param lifecycle_state: The lifecycle_state of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        allowed_values = ["MOVING", "PROVISIONING", "RUNNING", "STARTING", "STOPPING", "STOPPED", "SUSPENDING", "SUSPENDED", "CREATING_IMAGE", "TERMINATING", "TERMINATED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def display_name(self):
        """
        Gets the display_name of this ComputeGpuMemoryClusterInstanceSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ComputeGpuMemoryClusterInstanceSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this ComputeGpuMemoryClusterInstanceSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        Gets the time_created of this ComputeGpuMemoryClusterInstanceSummary.
        The date and time the GPU memory cluster instance was created.

        Example: `2016-09-15T21:10:29.600Z`


        :return: The time_created of this ComputeGpuMemoryClusterInstanceSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ComputeGpuMemoryClusterInstanceSummary.
        The date and time the GPU memory cluster instance was created.

        Example: `2016-09-15T21:10:29.600Z`


        :param time_created: The time_created of this ComputeGpuMemoryClusterInstanceSummary.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
