# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateImportRequestDetails(object):
    """
    Details of import object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateImportRequestDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param bucket_name:
            The value to assign to the bucket_name property of this CreateImportRequestDetails.
        :type bucket_name: str

        :param file_name:
            The value to assign to the file_name property of this CreateImportRequestDetails.
        :type file_name: str

        :param object_storage_tenancy_id:
            The value to assign to the object_storage_tenancy_id property of this CreateImportRequestDetails.
        :type object_storage_tenancy_id: str

        :param object_storage_region:
            The value to assign to the object_storage_region property of this CreateImportRequestDetails.
        :type object_storage_region: str

        :param object_key_for_import:
            The value to assign to the object_key_for_import property of this CreateImportRequestDetails.
        :type object_key_for_import: str

        :param are_data_asset_references_included:
            The value to assign to the are_data_asset_references_included property of this CreateImportRequestDetails.
        :type are_data_asset_references_included: bool

        :param import_conflict_resolution:
            The value to assign to the import_conflict_resolution property of this CreateImportRequestDetails.
        :type import_conflict_resolution: oci.data_integration.models.ImportConflictResolution

        """
        self.swagger_types = {
            'bucket_name': 'str',
            'file_name': 'str',
            'object_storage_tenancy_id': 'str',
            'object_storage_region': 'str',
            'object_key_for_import': 'str',
            'are_data_asset_references_included': 'bool',
            'import_conflict_resolution': 'ImportConflictResolution'
        }
        self.attribute_map = {
            'bucket_name': 'bucketName',
            'file_name': 'fileName',
            'object_storage_tenancy_id': 'objectStorageTenancyId',
            'object_storage_region': 'objectStorageRegion',
            'object_key_for_import': 'objectKeyForImport',
            'are_data_asset_references_included': 'areDataAssetReferencesIncluded',
            'import_conflict_resolution': 'importConflictResolution'
        }
        self._bucket_name = None
        self._file_name = None
        self._object_storage_tenancy_id = None
        self._object_storage_region = None
        self._object_key_for_import = None
        self._are_data_asset_references_included = None
        self._import_conflict_resolution = None

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this CreateImportRequestDetails.
        Name of the Object Storage bucket where the object will be imported from.


        :return: The bucket_name of this CreateImportRequestDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this CreateImportRequestDetails.
        Name of the Object Storage bucket where the object will be imported from.


        :param bucket_name: The bucket_name of this CreateImportRequestDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def file_name(self):
        """
        **[Required]** Gets the file_name of this CreateImportRequestDetails.
        Name of the zip file to be imported.


        :return: The file_name of this CreateImportRequestDetails.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """
        Sets the file_name of this CreateImportRequestDetails.
        Name of the zip file to be imported.


        :param file_name: The file_name of this CreateImportRequestDetails.
        :type: str
        """
        self._file_name = file_name

    @property
    def object_storage_tenancy_id(self):
        """
        Gets the object_storage_tenancy_id of this CreateImportRequestDetails.
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)


        :return: The object_storage_tenancy_id of this CreateImportRequestDetails.
        :rtype: str
        """
        return self._object_storage_tenancy_id

    @object_storage_tenancy_id.setter
    def object_storage_tenancy_id(self, object_storage_tenancy_id):
        """
        Sets the object_storage_tenancy_id of this CreateImportRequestDetails.
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)


        :param object_storage_tenancy_id: The object_storage_tenancy_id of this CreateImportRequestDetails.
        :type: str
        """
        self._object_storage_tenancy_id = object_storage_tenancy_id

    @property
    def object_storage_region(self):
        """
        Gets the object_storage_region of this CreateImportRequestDetails.
        Region of the object storage (if using object storage of different region)


        :return: The object_storage_region of this CreateImportRequestDetails.
        :rtype: str
        """
        return self._object_storage_region

    @object_storage_region.setter
    def object_storage_region(self, object_storage_region):
        """
        Sets the object_storage_region of this CreateImportRequestDetails.
        Region of the object storage (if using object storage of different region)


        :param object_storage_region: The object_storage_region of this CreateImportRequestDetails.
        :type: str
        """
        self._object_storage_region = object_storage_region

    @property
    def object_key_for_import(self):
        """
        Gets the object_key_for_import of this CreateImportRequestDetails.
        Key of the object inside which all the objects will be imported


        :return: The object_key_for_import of this CreateImportRequestDetails.
        :rtype: str
        """
        return self._object_key_for_import

    @object_key_for_import.setter
    def object_key_for_import(self, object_key_for_import):
        """
        Sets the object_key_for_import of this CreateImportRequestDetails.
        Key of the object inside which all the objects will be imported


        :param object_key_for_import: The object_key_for_import of this CreateImportRequestDetails.
        :type: str
        """
        self._object_key_for_import = object_key_for_import

    @property
    def are_data_asset_references_included(self):
        """
        Gets the are_data_asset_references_included of this CreateImportRequestDetails.
        This field controls if the data asset references will be included during import.


        :return: The are_data_asset_references_included of this CreateImportRequestDetails.
        :rtype: bool
        """
        return self._are_data_asset_references_included

    @are_data_asset_references_included.setter
    def are_data_asset_references_included(self, are_data_asset_references_included):
        """
        Sets the are_data_asset_references_included of this CreateImportRequestDetails.
        This field controls if the data asset references will be included during import.


        :param are_data_asset_references_included: The are_data_asset_references_included of this CreateImportRequestDetails.
        :type: bool
        """
        self._are_data_asset_references_included = are_data_asset_references_included

    @property
    def import_conflict_resolution(self):
        """
        Gets the import_conflict_resolution of this CreateImportRequestDetails.

        :return: The import_conflict_resolution of this CreateImportRequestDetails.
        :rtype: oci.data_integration.models.ImportConflictResolution
        """
        return self._import_conflict_resolution

    @import_conflict_resolution.setter
    def import_conflict_resolution(self, import_conflict_resolution):
        """
        Sets the import_conflict_resolution of this CreateImportRequestDetails.

        :param import_conflict_resolution: The import_conflict_resolution of this CreateImportRequestDetails.
        :type: oci.data_integration.models.ImportConflictResolution
        """
        self._import_conflict_resolution = import_conflict_resolution

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
