# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ShapeDetails(object):
    """
    OCI DataFlow Shape configuration. Use shapeOcpuParam and shapeMemoryParam config params for configuring number of OCPUs and memory in GBs respectively.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ShapeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_values:
            The value to assign to the config_values property of this ShapeDetails.
        :type config_values: oci.data_integration.models.ConfigValues

        """
        self.swagger_types = {
            'config_values': 'ConfigValues'
        }
        self.attribute_map = {
            'config_values': 'configValues'
        }
        self._config_values = None

    @property
    def config_values(self):
        """
        Gets the config_values of this ShapeDetails.

        :return: The config_values of this ShapeDetails.
        :rtype: oci.data_integration.models.ConfigValues
        """
        return self._config_values

    @config_values.setter
    def config_values(self, config_values):
        """
        Sets the config_values of this ShapeDetails.

        :param config_values: The config_values of this ShapeDetails.
        :type: oci.data_integration.models.ConfigValues
        """
        self._config_values = config_values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
