# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttributeSetSummary(object):
    """
    Summary details of an attribute set.
    """

    #: A constant which can be used with the in_use property of a AttributeSetSummary.
    #: This constant has a value of "YES"
    IN_USE_YES = "YES"

    #: A constant which can be used with the in_use property of a AttributeSetSummary.
    #: This constant has a value of "NO"
    IN_USE_NO = "NO"

    def __init__(self, **kwargs):
        """
        Initializes a new AttributeSetSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AttributeSetSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AttributeSetSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this AttributeSetSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AttributeSetSummary.
        :type description: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AttributeSetSummary.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this AttributeSetSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AttributeSetSummary.
        :type time_updated: datetime

        :param attribute_set_type:
            The value to assign to the attribute_set_type property of this AttributeSetSummary.
        :type attribute_set_type: str

        :param is_user_defined:
            The value to assign to the is_user_defined property of this AttributeSetSummary.
        :type is_user_defined: bool

        :param in_use:
            The value to assign to the in_use property of this AttributeSetSummary.
            Allowed values for this property are: "YES", "NO", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type in_use: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AttributeSetSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AttributeSetSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AttributeSetSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'attribute_set_type': 'str',
            'is_user_defined': 'bool',
            'in_use': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'attribute_set_type': 'attributeSetType',
            'is_user_defined': 'isUserDefined',
            'in_use': 'inUse',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._attribute_set_type = None
        self._is_user_defined = None
        self._in_use = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AttributeSetSummary.
        The OCID of an attribute set.


        :return: The id of this AttributeSetSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AttributeSetSummary.
        The OCID of an attribute set.


        :param id: The id of this AttributeSetSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AttributeSetSummary.
        The OCID of the compartment that contains attribute set.


        :return: The compartment_id of this AttributeSetSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AttributeSetSummary.
        The OCID of the compartment that contains attribute set.


        :param compartment_id: The compartment_id of this AttributeSetSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AttributeSetSummary.
        The display name of an attribute set. The name does not have to be unique, and is changeable.


        :return: The display_name of this AttributeSetSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AttributeSetSummary.
        The display name of an attribute set. The name does not have to be unique, and is changeable.


        :param display_name: The display_name of this AttributeSetSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this AttributeSetSummary.
        Description of an attribute set.


        :return: The description of this AttributeSetSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AttributeSetSummary.
        Description of an attribute set.


        :param description: The description of this AttributeSetSummary.
        :type: str
        """
        self._description = description

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AttributeSetSummary.
        The current state of an attribute set.


        :return: The lifecycle_state of this AttributeSetSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AttributeSetSummary.
        The current state of an attribute set.


        :param lifecycle_state: The lifecycle_state of this AttributeSetSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this AttributeSetSummary.
        The date and time an attribute set was created, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this AttributeSetSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AttributeSetSummary.
        The date and time an attribute set was created, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this AttributeSetSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this AttributeSetSummary.
        The date and time an attribute set was updated, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this AttributeSetSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AttributeSetSummary.
        The date and time an attribute set was updated, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this AttributeSetSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def attribute_set_type(self):
        """
        **[Required]** Gets the attribute_set_type of this AttributeSetSummary.
        The type of attribute set.


        :return: The attribute_set_type of this AttributeSetSummary.
        :rtype: str
        """
        return self._attribute_set_type

    @attribute_set_type.setter
    def attribute_set_type(self, attribute_set_type):
        """
        Sets the attribute_set_type of this AttributeSetSummary.
        The type of attribute set.


        :param attribute_set_type: The attribute_set_type of this AttributeSetSummary.
        :type: str
        """
        self._attribute_set_type = attribute_set_type

    @property
    def is_user_defined(self):
        """
        Gets the is_user_defined of this AttributeSetSummary.
        Indicates whether the attribute set is user defined or pre defined in Data Safe. Values can either be 'true' or 'false'.


        :return: The is_user_defined of this AttributeSetSummary.
        :rtype: bool
        """
        return self._is_user_defined

    @is_user_defined.setter
    def is_user_defined(self, is_user_defined):
        """
        Sets the is_user_defined of this AttributeSetSummary.
        Indicates whether the attribute set is user defined or pre defined in Data Safe. Values can either be 'true' or 'false'.


        :param is_user_defined: The is_user_defined of this AttributeSetSummary.
        :type: bool
        """
        self._is_user_defined = is_user_defined

    @property
    def in_use(self):
        """
        Gets the in_use of this AttributeSetSummary.
        Indicates whether the attribute set is in use by other resource.

        Allowed values for this property are: "YES", "NO", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The in_use of this AttributeSetSummary.
        :rtype: str
        """
        return self._in_use

    @in_use.setter
    def in_use(self, in_use):
        """
        Sets the in_use of this AttributeSetSummary.
        Indicates whether the attribute set is in use by other resource.


        :param in_use: The in_use of this AttributeSetSummary.
        :type: str
        """
        allowed_values = ["YES", "NO"]
        if not value_allowed_none_or_none_sentinel(in_use, allowed_values):
            in_use = 'UNKNOWN_ENUM_VALUE'
        self._in_use = in_use

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AttributeSetSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this AttributeSetSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AttributeSetSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this AttributeSetSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AttributeSetSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this AttributeSetSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AttributeSetSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this AttributeSetSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AttributeSetSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this AttributeSetSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AttributeSetSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this AttributeSetSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
