# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Column(object):
    """
    The description of the column.
    """

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "IN"
    APPLICABLE_OPERATORS_IN = "IN"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "EQ"
    APPLICABLE_OPERATORS_EQ = "EQ"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "EQ_CS"
    APPLICABLE_OPERATORS_EQ_CS = "EQ_CS"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "GT"
    APPLICABLE_OPERATORS_GT = "GT"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "GE"
    APPLICABLE_OPERATORS_GE = "GE"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "LT"
    APPLICABLE_OPERATORS_LT = "LT"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "LE"
    APPLICABLE_OPERATORS_LE = "LE"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "AND"
    APPLICABLE_OPERATORS_AND = "AND"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "OR"
    APPLICABLE_OPERATORS_OR = "OR"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "NE"
    APPLICABLE_OPERATORS_NE = "NE"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "CO"
    APPLICABLE_OPERATORS_CO = "CO"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "CO_CS"
    APPLICABLE_OPERATORS_CO_CS = "CO_CS"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "NOT"
    APPLICABLE_OPERATORS_NOT = "NOT"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "NOT_IN"
    APPLICABLE_OPERATORS_NOT_IN = "NOT_IN"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "IN_SET"
    APPLICABLE_OPERATORS_IN_SET = "IN_SET"

    #: A constant which can be used with the applicable_operators property of a Column.
    #: This constant has a value of "NOT_IN_SET"
    APPLICABLE_OPERATORS_NOT_IN_SET = "NOT_IN_SET"

    def __init__(self, **kwargs):
        """
        Initializes a new Column object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this Column.
        :type display_name: str

        :param field_name:
            The value to assign to the field_name property of this Column.
        :type field_name: str

        :param data_type:
            The value to assign to the data_type property of this Column.
        :type data_type: str

        :param is_hidden:
            The value to assign to the is_hidden property of this Column.
        :type is_hidden: bool

        :param display_order:
            The value to assign to the display_order property of this Column.
        :type display_order: int

        :param is_virtual:
            The value to assign to the is_virtual property of this Column.
        :type is_virtual: bool

        :param applicable_operators:
            The value to assign to the applicable_operators property of this Column.
            Allowed values for items in this list are: "IN", "EQ", "EQ_CS", "GT", "GE", "LT", "LE", "AND", "OR", "NE", "CO", "CO_CS", "NOT", "NOT_IN", "IN_SET", "NOT_IN_SET", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type applicable_operators: list[str]

        """
        self.swagger_types = {
            'display_name': 'str',
            'field_name': 'str',
            'data_type': 'str',
            'is_hidden': 'bool',
            'display_order': 'int',
            'is_virtual': 'bool',
            'applicable_operators': 'list[str]'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'field_name': 'fieldName',
            'data_type': 'dataType',
            'is_hidden': 'isHidden',
            'display_order': 'displayOrder',
            'is_virtual': 'isVirtual',
            'applicable_operators': 'applicableOperators'
        }
        self._display_name = None
        self._field_name = None
        self._data_type = None
        self._is_hidden = None
        self._display_order = None
        self._is_virtual = None
        self._applicable_operators = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Column.
        Name of the column displayed on UI.


        :return: The display_name of this Column.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Column.
        Name of the column displayed on UI.


        :param display_name: The display_name of this Column.
        :type: str
        """
        self._display_name = display_name

    @property
    def field_name(self):
        """
        **[Required]** Gets the field_name of this Column.
        Specifies the corresponding field name in the data source.


        :return: The field_name of this Column.
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """
        Sets the field_name of this Column.
        Specifies the corresponding field name in the data source.


        :param field_name: The field_name of this Column.
        :type: str
        """
        self._field_name = field_name

    @property
    def data_type(self):
        """
        Gets the data_type of this Column.
        Specifies the data type of the column.


        :return: The data_type of this Column.
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """
        Sets the data_type of this Column.
        Specifies the data type of the column.


        :param data_type: The data_type of this Column.
        :type: str
        """
        self._data_type = data_type

    @property
    def is_hidden(self):
        """
        **[Required]** Gets the is_hidden of this Column.
        Indicates if the column is hidden. Values can either be 'true' or 'false'.


        :return: The is_hidden of this Column.
        :rtype: bool
        """
        return self._is_hidden

    @is_hidden.setter
    def is_hidden(self, is_hidden):
        """
        Sets the is_hidden of this Column.
        Indicates if the column is hidden. Values can either be 'true' or 'false'.


        :param is_hidden: The is_hidden of this Column.
        :type: bool
        """
        self._is_hidden = is_hidden

    @property
    def display_order(self):
        """
        **[Required]** Gets the display_order of this Column.
        Specifies the display order of the column.


        :return: The display_order of this Column.
        :rtype: int
        """
        return self._display_order

    @display_order.setter
    def display_order(self, display_order):
        """
        Sets the display_order of this Column.
        Specifies the display order of the column.


        :param display_order: The display_order of this Column.
        :type: int
        """
        self._display_order = display_order

    @property
    def is_virtual(self):
        """
        Gets the is_virtual of this Column.
        Specifies if column is virtual and can only be used as column filter.


        :return: The is_virtual of this Column.
        :rtype: bool
        """
        return self._is_virtual

    @is_virtual.setter
    def is_virtual(self, is_virtual):
        """
        Sets the is_virtual of this Column.
        Specifies if column is virtual and can only be used as column filter.


        :param is_virtual: The is_virtual of this Column.
        :type: bool
        """
        self._is_virtual = is_virtual

    @property
    def applicable_operators(self):
        """
        Gets the applicable_operators of this Column.
        An array of operators that can be supported by column fieldName.

        Allowed values for items in this list are: "IN", "EQ", "EQ_CS", "GT", "GE", "LT", "LE", "AND", "OR", "NE", "CO", "CO_CS", "NOT", "NOT_IN", "IN_SET", "NOT_IN_SET", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The applicable_operators of this Column.
        :rtype: list[str]
        """
        return self._applicable_operators

    @applicable_operators.setter
    def applicable_operators(self, applicable_operators):
        """
        Sets the applicable_operators of this Column.
        An array of operators that can be supported by column fieldName.


        :param applicable_operators: The applicable_operators of this Column.
        :type: list[str]
        """
        allowed_values = ["IN", "EQ", "EQ_CS", "GT", "GE", "LT", "LE", "AND", "OR", "NE", "CO", "CO_CS", "NOT", "NOT_IN", "IN_SET", "NOT_IN_SET"]
        if applicable_operators:
            applicable_operators[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in applicable_operators]
        self._applicable_operators = applicable_operators

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
