# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ColumnsInfo(object):
    """
    columnsInfo object has details of column group with schema details.
    """

    #: A constant which can be used with the object_type property of a ColumnsInfo.
    #: This constant has a value of "TABLE"
    OBJECT_TYPE_TABLE = "TABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new ColumnsInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schema_name:
            The value to assign to the schema_name property of this ColumnsInfo.
        :type schema_name: str

        :param object_type:
            The value to assign to the object_type property of this ColumnsInfo.
            Allowed values for this property are: "TABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type object_type: str

        :param object_name:
            The value to assign to the object_name property of this ColumnsInfo.
        :type object_name: str

        :param app_name:
            The value to assign to the app_name property of this ColumnsInfo.
        :type app_name: str

        :param column_group:
            The value to assign to the column_group property of this ColumnsInfo.
        :type column_group: list[str]

        :param sensitive_type_ids:
            The value to assign to the sensitive_type_ids property of this ColumnsInfo.
        :type sensitive_type_ids: list[str]

        """
        self.swagger_types = {
            'schema_name': 'str',
            'object_type': 'str',
            'object_name': 'str',
            'app_name': 'str',
            'column_group': 'list[str]',
            'sensitive_type_ids': 'list[str]'
        }
        self.attribute_map = {
            'schema_name': 'schemaName',
            'object_type': 'objectType',
            'object_name': 'objectName',
            'app_name': 'appName',
            'column_group': 'columnGroup',
            'sensitive_type_ids': 'sensitiveTypeIds'
        }
        self._schema_name = None
        self._object_type = None
        self._object_name = None
        self._app_name = None
        self._column_group = None
        self._sensitive_type_ids = None

    @property
    def schema_name(self):
        """
        **[Required]** Gets the schema_name of this ColumnsInfo.
        The schema name.


        :return: The schema_name of this ColumnsInfo.
        :rtype: str
        """
        return self._schema_name

    @schema_name.setter
    def schema_name(self, schema_name):
        """
        Sets the schema_name of this ColumnsInfo.
        The schema name.


        :param schema_name: The schema_name of this ColumnsInfo.
        :type: str
        """
        self._schema_name = schema_name

    @property
    def object_type(self):
        """
        **[Required]** Gets the object_type of this ColumnsInfo.
        The type of the database object that contains the sensitive column.

        Allowed values for this property are: "TABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The object_type of this ColumnsInfo.
        :rtype: str
        """
        return self._object_type

    @object_type.setter
    def object_type(self, object_type):
        """
        Sets the object_type of this ColumnsInfo.
        The type of the database object that contains the sensitive column.


        :param object_type: The object_type of this ColumnsInfo.
        :type: str
        """
        allowed_values = ["TABLE"]
        if not value_allowed_none_or_none_sentinel(object_type, allowed_values):
            object_type = 'UNKNOWN_ENUM_VALUE'
        self._object_type = object_type

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this ColumnsInfo.
        The database object that contains the columns.


        :return: The object_name of this ColumnsInfo.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this ColumnsInfo.
        The database object that contains the columns.


        :param object_name: The object_name of this ColumnsInfo.
        :type: str
        """
        self._object_name = object_name

    @property
    def app_name(self):
        """
        **[Required]** Gets the app_name of this ColumnsInfo.
        The application name.


        :return: The app_name of this ColumnsInfo.
        :rtype: str
        """
        return self._app_name

    @app_name.setter
    def app_name(self, app_name):
        """
        Sets the app_name of this ColumnsInfo.
        The application name.


        :param app_name: The app_name of this ColumnsInfo.
        :type: str
        """
        self._app_name = app_name

    @property
    def column_group(self):
        """
        **[Required]** Gets the column_group of this ColumnsInfo.
        Group of columns in referential relation. Order needs to be maintained in the elements of the parent/child array listing.


        :return: The column_group of this ColumnsInfo.
        :rtype: list[str]
        """
        return self._column_group

    @column_group.setter
    def column_group(self, column_group):
        """
        Sets the column_group of this ColumnsInfo.
        Group of columns in referential relation. Order needs to be maintained in the elements of the parent/child array listing.


        :param column_group: The column_group of this ColumnsInfo.
        :type: list[str]
        """
        self._column_group = column_group

    @property
    def sensitive_type_ids(self):
        """
        Gets the sensitive_type_ids of this ColumnsInfo.
        Sensitive type ocids of each column groups. Order needs to be maintained with the parent column group.
        For the DB defined referential relations identified during SDM creation, we cannot add sensitive types.
        Instead use the sensitiveColumn POST API to mark the columns sensitive.


        :return: The sensitive_type_ids of this ColumnsInfo.
        :rtype: list[str]
        """
        return self._sensitive_type_ids

    @sensitive_type_ids.setter
    def sensitive_type_ids(self, sensitive_type_ids):
        """
        Sets the sensitive_type_ids of this ColumnsInfo.
        Sensitive type ocids of each column groups. Order needs to be maintained with the parent column group.
        For the DB defined referential relations identified during SDM creation, we cannot add sensitive types.
        Instead use the sensitiveColumn POST API to mark the columns sensitive.


        :param sensitive_type_ids: The sensitive_type_ids of this ColumnsInfo.
        :type: list[str]
        """
        self._sensitive_type_ids = sensitive_type_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
