# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenerateHealthReportDetails(object):
    """
    Details to use when performing health check on a masking policy.
    """

    #: A constant which can be used with the check_type property of a GenerateHealthReportDetails.
    #: This constant has a value of "ALL"
    CHECK_TYPE_ALL = "ALL"

    def __init__(self, **kwargs):
        """
        Initializes a new GenerateHealthReportDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param check_type:
            The value to assign to the check_type property of this GenerateHealthReportDetails.
            Allowed values for this property are: "ALL"
        :type check_type: str

        :param target_id:
            The value to assign to the target_id property of this GenerateHealthReportDetails.
        :type target_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this GenerateHealthReportDetails.
        :type compartment_id: str

        :param tablespace:
            The value to assign to the tablespace property of this GenerateHealthReportDetails.
        :type tablespace: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this GenerateHealthReportDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this GenerateHealthReportDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'check_type': 'str',
            'target_id': 'str',
            'compartment_id': 'str',
            'tablespace': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'check_type': 'checkType',
            'target_id': 'targetId',
            'compartment_id': 'compartmentId',
            'tablespace': 'tablespace',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._check_type = None
        self._target_id = None
        self._compartment_id = None
        self._tablespace = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def check_type(self):
        """
        Gets the check_type of this GenerateHealthReportDetails.
        The type of health check. The default behaviour is to perform all health checks.

        Allowed values for this property are: "ALL"


        :return: The check_type of this GenerateHealthReportDetails.
        :rtype: str
        """
        return self._check_type

    @check_type.setter
    def check_type(self, check_type):
        """
        Sets the check_type of this GenerateHealthReportDetails.
        The type of health check. The default behaviour is to perform all health checks.


        :param check_type: The check_type of this GenerateHealthReportDetails.
        :type: str
        """
        allowed_values = ["ALL"]
        if not value_allowed_none_or_none_sentinel(check_type, allowed_values):
            raise ValueError(
                f"Invalid value for `check_type`, must be None or one of {allowed_values}"
            )
        self._check_type = check_type

    @property
    def target_id(self):
        """
        Gets the target_id of this GenerateHealthReportDetails.
        The OCID of the target database to use for the masking policy
        health check. The targetId associated with the masking policy
        is used if this is not passed.


        :return: The target_id of this GenerateHealthReportDetails.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this GenerateHealthReportDetails.
        The OCID of the target database to use for the masking policy
        health check. The targetId associated with the masking policy
        is used if this is not passed.


        :param target_id: The target_id of this GenerateHealthReportDetails.
        :type: str
        """
        self._target_id = target_id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this GenerateHealthReportDetails.
        The OCID of the compartment where the health report resource should be created.


        :return: The compartment_id of this GenerateHealthReportDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this GenerateHealthReportDetails.
        The OCID of the compartment where the health report resource should be created.


        :param compartment_id: The compartment_id of this GenerateHealthReportDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def tablespace(self):
        """
        Gets the tablespace of this GenerateHealthReportDetails.
        The tablespace that should be used to estimate space.
        If no tablespace is provided, the DEFAULT tablespace is used.


        :return: The tablespace of this GenerateHealthReportDetails.
        :rtype: str
        """
        return self._tablespace

    @tablespace.setter
    def tablespace(self, tablespace):
        """
        Sets the tablespace of this GenerateHealthReportDetails.
        The tablespace that should be used to estimate space.
        If no tablespace is provided, the DEFAULT tablespace is used.


        :param tablespace: The tablespace of this GenerateHealthReportDetails.
        :type: str
        """
        self._tablespace = tablespace

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this GenerateHealthReportDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this GenerateHealthReportDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this GenerateHealthReportDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this GenerateHealthReportDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this GenerateHealthReportDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this GenerateHealthReportDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this GenerateHealthReportDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this GenerateHealthReportDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
