# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Include(object):
    """
    Criteria to determine whether a target database should be included in the target database group.
    If the database satisfies any of compartments, targetDatabaseIds, freeformTags, or definedTags criteria, it qualifies for inclusion in the target database group
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Include object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartments:
            The value to assign to the compartments property of this Include.
        :type compartments: list[oci.data_safe.models.Compartments]

        :param target_database_ids:
            The value to assign to the target_database_ids property of this Include.
        :type target_database_ids: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Include.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Include.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartments': 'list[Compartments]',
            'target_database_ids': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartments': 'compartments',
            'target_database_ids': 'targetDatabaseIds',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartments = None
        self._target_database_ids = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartments(self):
        """
        Gets the compartments of this Include.
        List of compartment objects, each containing the OCID of the compartment and a boolean value that indicates whether the target databases in the compartments and sub-compartments should also be included in the target database group.


        :return: The compartments of this Include.
        :rtype: list[oci.data_safe.models.Compartments]
        """
        return self._compartments

    @compartments.setter
    def compartments(self, compartments):
        """
        Sets the compartments of this Include.
        List of compartment objects, each containing the OCID of the compartment and a boolean value that indicates whether the target databases in the compartments and sub-compartments should also be included in the target database group.


        :param compartments: The compartments of this Include.
        :type: list[oci.data_safe.models.Compartments]
        """
        self._compartments = compartments

    @property
    def target_database_ids(self):
        """
        Gets the target_database_ids of this Include.
        The list of target database OCIDs to be included in the target database group.


        :return: The target_database_ids of this Include.
        :rtype: list[str]
        """
        return self._target_database_ids

    @target_database_ids.setter
    def target_database_ids(self, target_database_ids):
        """
        Sets the target_database_ids of this Include.
        The list of target database OCIDs to be included in the target database group.


        :param target_database_ids: The target_database_ids of this Include.
        :type: list[str]
        """
        self._target_database_ids = target_database_ids

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Include.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this Include.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Include.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this Include.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Include.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this Include.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Include.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this Include.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
