# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaskingErrorSummary(object):
    """
    Summary of a masking error. A Masking error is an error seen during the masking run.
    """

    #: A constant which can be used with the step_name property of a MaskingErrorSummary.
    #: This constant has a value of "VALIDATE"
    STEP_NAME_VALIDATE = "VALIDATE"

    #: A constant which can be used with the step_name property of a MaskingErrorSummary.
    #: This constant has a value of "GENERATE_SCRIPT"
    STEP_NAME_GENERATE_SCRIPT = "GENERATE_SCRIPT"

    #: A constant which can be used with the step_name property of a MaskingErrorSummary.
    #: This constant has a value of "EXECUTE_MASKING"
    STEP_NAME_EXECUTE_MASKING = "EXECUTE_MASKING"

    #: A constant which can be used with the step_name property of a MaskingErrorSummary.
    #: This constant has a value of "PRE_MASKING"
    STEP_NAME_PRE_MASKING = "PRE_MASKING"

    #: A constant which can be used with the step_name property of a MaskingErrorSummary.
    #: This constant has a value of "POST_MASKING"
    STEP_NAME_POST_MASKING = "POST_MASKING"

    def __init__(self, **kwargs):
        """
        Initializes a new MaskingErrorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param step_name:
            The value to assign to the step_name property of this MaskingErrorSummary.
            Allowed values for this property are: "VALIDATE", "GENERATE_SCRIPT", "EXECUTE_MASKING", "PRE_MASKING", "POST_MASKING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type step_name: str

        :param error:
            The value to assign to the error property of this MaskingErrorSummary.
        :type error: str

        :param failed_statement:
            The value to assign to the failed_statement property of this MaskingErrorSummary.
        :type failed_statement: str

        :param time_created:
            The value to assign to the time_created property of this MaskingErrorSummary.
        :type time_created: datetime

        """
        self.swagger_types = {
            'step_name': 'str',
            'error': 'str',
            'failed_statement': 'str',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'step_name': 'stepName',
            'error': 'error',
            'failed_statement': 'failedStatement',
            'time_created': 'timeCreated'
        }
        self._step_name = None
        self._error = None
        self._failed_statement = None
        self._time_created = None

    @property
    def step_name(self):
        """
        **[Required]** Gets the step_name of this MaskingErrorSummary.
        The stepName of the masking error.

        Allowed values for this property are: "VALIDATE", "GENERATE_SCRIPT", "EXECUTE_MASKING", "PRE_MASKING", "POST_MASKING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The step_name of this MaskingErrorSummary.
        :rtype: str
        """
        return self._step_name

    @step_name.setter
    def step_name(self, step_name):
        """
        Sets the step_name of this MaskingErrorSummary.
        The stepName of the masking error.


        :param step_name: The step_name of this MaskingErrorSummary.
        :type: str
        """
        allowed_values = ["VALIDATE", "GENERATE_SCRIPT", "EXECUTE_MASKING", "PRE_MASKING", "POST_MASKING"]
        if not value_allowed_none_or_none_sentinel(step_name, allowed_values):
            step_name = 'UNKNOWN_ENUM_VALUE'
        self._step_name = step_name

    @property
    def error(self):
        """
        **[Required]** Gets the error of this MaskingErrorSummary.
        The text of the masking error.


        :return: The error of this MaskingErrorSummary.
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """
        Sets the error of this MaskingErrorSummary.
        The text of the masking error.


        :param error: The error of this MaskingErrorSummary.
        :type: str
        """
        self._error = error

    @property
    def failed_statement(self):
        """
        Gets the failed_statement of this MaskingErrorSummary.
        The statement resulting into the error.


        :return: The failed_statement of this MaskingErrorSummary.
        :rtype: str
        """
        return self._failed_statement

    @failed_statement.setter
    def failed_statement(self, failed_statement):
        """
        Sets the failed_statement of this MaskingErrorSummary.
        The statement resulting into the error.


        :param failed_statement: The failed_statement of this MaskingErrorSummary.
        :type: str
        """
        self._failed_statement = failed_statement

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MaskingErrorSummary.
        The date and time the error entry was created, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this MaskingErrorSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MaskingErrorSummary.
        The date and time the error entry was created, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this MaskingErrorSummary.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
