# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaskingPolicyReferentialRelationSummary(object):
    """
    A referential relation is a resource corresponding to database columns.
    It is always associated with a masking policy.
    """

    #: A constant which can be used with the relation_type property of a MaskingPolicyReferentialRelationSummary.
    #: This constant has a value of "NONE"
    RELATION_TYPE_NONE = "NONE"

    #: A constant which can be used with the relation_type property of a MaskingPolicyReferentialRelationSummary.
    #: This constant has a value of "APP_DEFINED"
    RELATION_TYPE_APP_DEFINED = "APP_DEFINED"

    #: A constant which can be used with the relation_type property of a MaskingPolicyReferentialRelationSummary.
    #: This constant has a value of "DB_DEFINED"
    RELATION_TYPE_DB_DEFINED = "DB_DEFINED"

    def __init__(self, **kwargs):
        """
        Initializes a new MaskingPolicyReferentialRelationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param masking_policy_id:
            The value to assign to the masking_policy_id property of this MaskingPolicyReferentialRelationSummary.
        :type masking_policy_id: str

        :param relation_type:
            The value to assign to the relation_type property of this MaskingPolicyReferentialRelationSummary.
            Allowed values for this property are: "NONE", "APP_DEFINED", "DB_DEFINED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type relation_type: str

        :param parent:
            The value to assign to the parent property of this MaskingPolicyReferentialRelationSummary.
        :type parent: oci.data_safe.models.MaskingPolicyColumnsInfo

        :param child:
            The value to assign to the child property of this MaskingPolicyReferentialRelationSummary.
        :type child: oci.data_safe.models.MaskingPolicyColumnsInfo

        :param masking_format:
            The value to assign to the masking_format property of this MaskingPolicyReferentialRelationSummary.
        :type masking_format: list[str]

        """
        self.swagger_types = {
            'masking_policy_id': 'str',
            'relation_type': 'str',
            'parent': 'MaskingPolicyColumnsInfo',
            'child': 'MaskingPolicyColumnsInfo',
            'masking_format': 'list[str]'
        }
        self.attribute_map = {
            'masking_policy_id': 'maskingPolicyId',
            'relation_type': 'relationType',
            'parent': 'parent',
            'child': 'child',
            'masking_format': 'maskingFormat'
        }
        self._masking_policy_id = None
        self._relation_type = None
        self._parent = None
        self._child = None
        self._masking_format = None

    @property
    def masking_policy_id(self):
        """
        **[Required]** Gets the masking_policy_id of this MaskingPolicyReferentialRelationSummary.
        The OCID of the masking policy that contains the column.


        :return: The masking_policy_id of this MaskingPolicyReferentialRelationSummary.
        :rtype: str
        """
        return self._masking_policy_id

    @masking_policy_id.setter
    def masking_policy_id(self, masking_policy_id):
        """
        Sets the masking_policy_id of this MaskingPolicyReferentialRelationSummary.
        The OCID of the masking policy that contains the column.


        :param masking_policy_id: The masking_policy_id of this MaskingPolicyReferentialRelationSummary.
        :type: str
        """
        self._masking_policy_id = masking_policy_id

    @property
    def relation_type(self):
        """
        **[Required]** Gets the relation_type of this MaskingPolicyReferentialRelationSummary.
        The type of referential relationship the column has with its parent. DB_DEFINED indicates that the relationship is defined in the database
        dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.

        Allowed values for this property are: "NONE", "APP_DEFINED", "DB_DEFINED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The relation_type of this MaskingPolicyReferentialRelationSummary.
        :rtype: str
        """
        return self._relation_type

    @relation_type.setter
    def relation_type(self, relation_type):
        """
        Sets the relation_type of this MaskingPolicyReferentialRelationSummary.
        The type of referential relationship the column has with its parent. DB_DEFINED indicates that the relationship is defined in the database
        dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.


        :param relation_type: The relation_type of this MaskingPolicyReferentialRelationSummary.
        :type: str
        """
        allowed_values = ["NONE", "APP_DEFINED", "DB_DEFINED"]
        if not value_allowed_none_or_none_sentinel(relation_type, allowed_values):
            relation_type = 'UNKNOWN_ENUM_VALUE'
        self._relation_type = relation_type

    @property
    def parent(self):
        """
        **[Required]** Gets the parent of this MaskingPolicyReferentialRelationSummary.

        :return: The parent of this MaskingPolicyReferentialRelationSummary.
        :rtype: oci.data_safe.models.MaskingPolicyColumnsInfo
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """
        Sets the parent of this MaskingPolicyReferentialRelationSummary.

        :param parent: The parent of this MaskingPolicyReferentialRelationSummary.
        :type: oci.data_safe.models.MaskingPolicyColumnsInfo
        """
        self._parent = parent

    @property
    def child(self):
        """
        **[Required]** Gets the child of this MaskingPolicyReferentialRelationSummary.

        :return: The child of this MaskingPolicyReferentialRelationSummary.
        :rtype: oci.data_safe.models.MaskingPolicyColumnsInfo
        """
        return self._child

    @child.setter
    def child(self, child):
        """
        Sets the child of this MaskingPolicyReferentialRelationSummary.

        :param child: The child of this MaskingPolicyReferentialRelationSummary.
        :type: oci.data_safe.models.MaskingPolicyColumnsInfo
        """
        self._child = child

    @property
    def masking_format(self):
        """
        Gets the masking_format of this MaskingPolicyReferentialRelationSummary.
        The masking format associated with the parent column.


        :return: The masking_format of this MaskingPolicyReferentialRelationSummary.
        :rtype: list[str]
        """
        return self._masking_format

    @masking_format.setter
    def masking_format(self, masking_format):
        """
        Sets the masking_format of this MaskingPolicyReferentialRelationSummary.
        The masking format associated with the parent column.


        :param masking_format: The masking_format of this MaskingPolicyReferentialRelationSummary.
        :type: list[str]
        """
        self._masking_format = masking_format

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
