# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SensitiveColumnAnalyticsDimensions(object):
    """
    The dimensions available for sensitive column analytics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SensitiveColumnAnalyticsDimensions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_id:
            The value to assign to the target_id property of this SensitiveColumnAnalyticsDimensions.
        :type target_id: str

        :param schema_name:
            The value to assign to the schema_name property of this SensitiveColumnAnalyticsDimensions.
        :type schema_name: str

        :param object_name:
            The value to assign to the object_name property of this SensitiveColumnAnalyticsDimensions.
        :type object_name: str

        :param column_name:
            The value to assign to the column_name property of this SensitiveColumnAnalyticsDimensions.
        :type column_name: str

        :param sensitive_type_id:
            The value to assign to the sensitive_type_id property of this SensitiveColumnAnalyticsDimensions.
        :type sensitive_type_id: str

        :param sensitive_data_model_id:
            The value to assign to the sensitive_data_model_id property of this SensitiveColumnAnalyticsDimensions.
        :type sensitive_data_model_id: str

        """
        self.swagger_types = {
            'target_id': 'str',
            'schema_name': 'str',
            'object_name': 'str',
            'column_name': 'str',
            'sensitive_type_id': 'str',
            'sensitive_data_model_id': 'str'
        }
        self.attribute_map = {
            'target_id': 'targetId',
            'schema_name': 'schemaName',
            'object_name': 'objectName',
            'column_name': 'columnName',
            'sensitive_type_id': 'sensitiveTypeId',
            'sensitive_data_model_id': 'sensitiveDataModelId'
        }
        self._target_id = None
        self._schema_name = None
        self._object_name = None
        self._column_name = None
        self._sensitive_type_id = None
        self._sensitive_data_model_id = None

    @property
    def target_id(self):
        """
        Gets the target_id of this SensitiveColumnAnalyticsDimensions.
        The OCID of the target database associated with the sensitive column.


        :return: The target_id of this SensitiveColumnAnalyticsDimensions.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this SensitiveColumnAnalyticsDimensions.
        The OCID of the target database associated with the sensitive column.


        :param target_id: The target_id of this SensitiveColumnAnalyticsDimensions.
        :type: str
        """
        self._target_id = target_id

    @property
    def schema_name(self):
        """
        Gets the schema_name of this SensitiveColumnAnalyticsDimensions.
        The database schema that contains the sensitive column.


        :return: The schema_name of this SensitiveColumnAnalyticsDimensions.
        :rtype: str
        """
        return self._schema_name

    @schema_name.setter
    def schema_name(self, schema_name):
        """
        Sets the schema_name of this SensitiveColumnAnalyticsDimensions.
        The database schema that contains the sensitive column.


        :param schema_name: The schema_name of this SensitiveColumnAnalyticsDimensions.
        :type: str
        """
        self._schema_name = schema_name

    @property
    def object_name(self):
        """
        Gets the object_name of this SensitiveColumnAnalyticsDimensions.
        The database object that contains the sensitive column.


        :return: The object_name of this SensitiveColumnAnalyticsDimensions.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this SensitiveColumnAnalyticsDimensions.
        The database object that contains the sensitive column.


        :param object_name: The object_name of this SensitiveColumnAnalyticsDimensions.
        :type: str
        """
        self._object_name = object_name

    @property
    def column_name(self):
        """
        Gets the column_name of this SensitiveColumnAnalyticsDimensions.
        The name of the sensitive column.


        :return: The column_name of this SensitiveColumnAnalyticsDimensions.
        :rtype: str
        """
        return self._column_name

    @column_name.setter
    def column_name(self, column_name):
        """
        Sets the column_name of this SensitiveColumnAnalyticsDimensions.
        The name of the sensitive column.


        :param column_name: The column_name of this SensitiveColumnAnalyticsDimensions.
        :type: str
        """
        self._column_name = column_name

    @property
    def sensitive_type_id(self):
        """
        Gets the sensitive_type_id of this SensitiveColumnAnalyticsDimensions.
        The OCID of the sensitive type associated with the sensitive column.


        :return: The sensitive_type_id of this SensitiveColumnAnalyticsDimensions.
        :rtype: str
        """
        return self._sensitive_type_id

    @sensitive_type_id.setter
    def sensitive_type_id(self, sensitive_type_id):
        """
        Sets the sensitive_type_id of this SensitiveColumnAnalyticsDimensions.
        The OCID of the sensitive type associated with the sensitive column.


        :param sensitive_type_id: The sensitive_type_id of this SensitiveColumnAnalyticsDimensions.
        :type: str
        """
        self._sensitive_type_id = sensitive_type_id

    @property
    def sensitive_data_model_id(self):
        """
        Gets the sensitive_data_model_id of this SensitiveColumnAnalyticsDimensions.
        The OCID of the sensitive data model which contains the sensitive column.


        :return: The sensitive_data_model_id of this SensitiveColumnAnalyticsDimensions.
        :rtype: str
        """
        return self._sensitive_data_model_id

    @sensitive_data_model_id.setter
    def sensitive_data_model_id(self, sensitive_data_model_id):
        """
        Sets the sensitive_data_model_id of this SensitiveColumnAnalyticsDimensions.
        The OCID of the sensitive data model which contains the sensitive column.


        :param sensitive_data_model_id: The sensitive_data_model_id of this SensitiveColumnAnalyticsDimensions.
        :type: str
        """
        self._sensitive_data_model_id = sensitive_data_model_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
