# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAttributeSetDetails(object):
    """
    Details to update an attribute set.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAttributeSetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateAttributeSetDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateAttributeSetDetails.
        :type description: str

        :param attribute_set_values:
            The value to assign to the attribute_set_values property of this UpdateAttributeSetDetails.
        :type attribute_set_values: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAttributeSetDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAttributeSetDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'attribute_set_values': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'attribute_set_values': 'attributeSetValues',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._attribute_set_values = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateAttributeSetDetails.
        The display name of an attribute set. The name does not have to be unique, and is changeable.


        :return: The display_name of this UpdateAttributeSetDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateAttributeSetDetails.
        The display name of an attribute set. The name does not have to be unique, and is changeable.


        :param display_name: The display_name of this UpdateAttributeSetDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateAttributeSetDetails.
        The description of an attribute set.


        :return: The description of this UpdateAttributeSetDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateAttributeSetDetails.
        The description of an attribute set.


        :param description: The description of this UpdateAttributeSetDetails.
        :type: str
        """
        self._description = description

    @property
    def attribute_set_values(self):
        """
        Gets the attribute_set_values of this UpdateAttributeSetDetails.
        The list of attribute set values that will replace existing values.


        :return: The attribute_set_values of this UpdateAttributeSetDetails.
        :rtype: list[str]
        """
        return self._attribute_set_values

    @attribute_set_values.setter
    def attribute_set_values(self, attribute_set_values):
        """
        Sets the attribute_set_values of this UpdateAttributeSetDetails.
        The list of attribute set values that will replace existing values.


        :param attribute_set_values: The attribute_set_values of this UpdateAttributeSetDetails.
        :type: list[str]
        """
        self._attribute_set_values = attribute_set_values

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateAttributeSetDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateAttributeSetDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateAttributeSetDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateAttributeSetDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateAttributeSetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateAttributeSetDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateAttributeSetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateAttributeSetDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
