# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .model_group_clone_source_details import ModelGroupCloneSourceDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloneCreateFromModelGroupVersionHistoryDetails(ModelGroupCloneSourceDetails):
    """
    Parameters needed to cloning a model group from latest model group in model group version history.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloneCreateFromModelGroupVersionHistoryDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.CloneCreateFromModelGroupVersionHistoryDetails.model_group_clone_source_type` attribute
        of this class is ``MODEL_GROUP_VERSION_HISTORY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_group_clone_source_type:
            The value to assign to the model_group_clone_source_type property of this CloneCreateFromModelGroupVersionHistoryDetails.
            Allowed values for this property are: "MODEL_GROUP", "MODEL_GROUP_VERSION_HISTORY"
        :type model_group_clone_source_type: str

        :param source_id:
            The value to assign to the source_id property of this CloneCreateFromModelGroupVersionHistoryDetails.
        :type source_id: str

        :param modify_model_group_details:
            The value to assign to the modify_model_group_details property of this CloneCreateFromModelGroupVersionHistoryDetails.
        :type modify_model_group_details: oci.data_science.models.ModifyModelGroupDetails

        :param patch_model_group_member_model_details:
            The value to assign to the patch_model_group_member_model_details property of this CloneCreateFromModelGroupVersionHistoryDetails.
        :type patch_model_group_member_model_details: oci.data_science.models.PatchModelGroupMemberModelDetails

        """
        self.swagger_types = {
            'model_group_clone_source_type': 'str',
            'source_id': 'str',
            'modify_model_group_details': 'ModifyModelGroupDetails',
            'patch_model_group_member_model_details': 'PatchModelGroupMemberModelDetails'
        }
        self.attribute_map = {
            'model_group_clone_source_type': 'modelGroupCloneSourceType',
            'source_id': 'sourceId',
            'modify_model_group_details': 'modifyModelGroupDetails',
            'patch_model_group_member_model_details': 'patchModelGroupMemberModelDetails'
        }
        self._model_group_clone_source_type = None
        self._source_id = None
        self._modify_model_group_details = None
        self._patch_model_group_member_model_details = None
        self._model_group_clone_source_type = 'MODEL_GROUP_VERSION_HISTORY'

    @property
    def source_id(self):
        """
        **[Required]** Gets the source_id of this CloneCreateFromModelGroupVersionHistoryDetails.
        The `OCID`__ of the model group version history.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The source_id of this CloneCreateFromModelGroupVersionHistoryDetails.
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id):
        """
        Sets the source_id of this CloneCreateFromModelGroupVersionHistoryDetails.
        The `OCID`__ of the model group version history.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param source_id: The source_id of this CloneCreateFromModelGroupVersionHistoryDetails.
        :type: str
        """
        self._source_id = source_id

    @property
    def modify_model_group_details(self):
        """
        Gets the modify_model_group_details of this CloneCreateFromModelGroupVersionHistoryDetails.

        :return: The modify_model_group_details of this CloneCreateFromModelGroupVersionHistoryDetails.
        :rtype: oci.data_science.models.ModifyModelGroupDetails
        """
        return self._modify_model_group_details

    @modify_model_group_details.setter
    def modify_model_group_details(self, modify_model_group_details):
        """
        Sets the modify_model_group_details of this CloneCreateFromModelGroupVersionHistoryDetails.

        :param modify_model_group_details: The modify_model_group_details of this CloneCreateFromModelGroupVersionHistoryDetails.
        :type: oci.data_science.models.ModifyModelGroupDetails
        """
        self._modify_model_group_details = modify_model_group_details

    @property
    def patch_model_group_member_model_details(self):
        """
        Gets the patch_model_group_member_model_details of this CloneCreateFromModelGroupVersionHistoryDetails.

        :return: The patch_model_group_member_model_details of this CloneCreateFromModelGroupVersionHistoryDetails.
        :rtype: oci.data_science.models.PatchModelGroupMemberModelDetails
        """
        return self._patch_model_group_member_model_details

    @patch_model_group_member_model_details.setter
    def patch_model_group_member_model_details(self, patch_model_group_member_model_details):
        """
        Sets the patch_model_group_member_model_details of this CloneCreateFromModelGroupVersionHistoryDetails.

        :param patch_model_group_member_model_details: The patch_model_group_member_model_details of this CloneCreateFromModelGroupVersionHistoryDetails.
        :type: oci.data_science.models.PatchModelGroupMemberModelDetails
        """
        self._patch_model_group_member_model_details = patch_model_group_member_model_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
