# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMlApplicationInstanceDetails(object):
    """
    The information about new MlApplicationInstance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMlApplicationInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateMlApplicationInstanceDetails.
        :type display_name: str

        :param ml_application_id:
            The value to assign to the ml_application_id property of this CreateMlApplicationInstanceDetails.
        :type ml_application_id: str

        :param ml_application_implementation_id:
            The value to assign to the ml_application_implementation_id property of this CreateMlApplicationInstanceDetails.
        :type ml_application_implementation_id: str

        :param auth_configuration:
            The value to assign to the auth_configuration property of this CreateMlApplicationInstanceDetails.
        :type auth_configuration: oci.data_science.models.CreateAuthConfigurationDetails

        :param configuration:
            The value to assign to the configuration property of this CreateMlApplicationInstanceDetails.
        :type configuration: list[oci.data_science.models.ConfigurationProperty]

        :param is_enabled:
            The value to assign to the is_enabled property of this CreateMlApplicationInstanceDetails.
        :type is_enabled: bool

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateMlApplicationInstanceDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateMlApplicationInstanceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateMlApplicationInstanceDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'ml_application_id': 'str',
            'ml_application_implementation_id': 'str',
            'auth_configuration': 'CreateAuthConfigurationDetails',
            'configuration': 'list[ConfigurationProperty]',
            'is_enabled': 'bool',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'ml_application_id': 'mlApplicationId',
            'ml_application_implementation_id': 'mlApplicationImplementationId',
            'auth_configuration': 'authConfiguration',
            'configuration': 'configuration',
            'is_enabled': 'isEnabled',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._ml_application_id = None
        self._ml_application_implementation_id = None
        self._auth_configuration = None
        self._configuration = None
        self._is_enabled = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateMlApplicationInstanceDetails.
        The name of MlApplicationInstance. System will generate displayName when not provided.


        :return: The display_name of this CreateMlApplicationInstanceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateMlApplicationInstanceDetails.
        The name of MlApplicationInstance. System will generate displayName when not provided.


        :param display_name: The display_name of this CreateMlApplicationInstanceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def ml_application_id(self):
        """
        **[Required]** Gets the ml_application_id of this CreateMlApplicationInstanceDetails.
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.


        :return: The ml_application_id of this CreateMlApplicationInstanceDetails.
        :rtype: str
        """
        return self._ml_application_id

    @ml_application_id.setter
    def ml_application_id(self, ml_application_id):
        """
        Sets the ml_application_id of this CreateMlApplicationInstanceDetails.
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.


        :param ml_application_id: The ml_application_id of this CreateMlApplicationInstanceDetails.
        :type: str
        """
        self._ml_application_id = ml_application_id

    @property
    def ml_application_implementation_id(self):
        """
        **[Required]** Gets the ml_application_implementation_id of this CreateMlApplicationInstanceDetails.
        The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)


        :return: The ml_application_implementation_id of this CreateMlApplicationInstanceDetails.
        :rtype: str
        """
        return self._ml_application_implementation_id

    @ml_application_implementation_id.setter
    def ml_application_implementation_id(self, ml_application_implementation_id):
        """
        Sets the ml_application_implementation_id of this CreateMlApplicationInstanceDetails.
        The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)


        :param ml_application_implementation_id: The ml_application_implementation_id of this CreateMlApplicationInstanceDetails.
        :type: str
        """
        self._ml_application_implementation_id = ml_application_implementation_id

    @property
    def auth_configuration(self):
        """
        Gets the auth_configuration of this CreateMlApplicationInstanceDetails.

        :return: The auth_configuration of this CreateMlApplicationInstanceDetails.
        :rtype: oci.data_science.models.CreateAuthConfigurationDetails
        """
        return self._auth_configuration

    @auth_configuration.setter
    def auth_configuration(self, auth_configuration):
        """
        Sets the auth_configuration of this CreateMlApplicationInstanceDetails.

        :param auth_configuration: The auth_configuration of this CreateMlApplicationInstanceDetails.
        :type: oci.data_science.models.CreateAuthConfigurationDetails
        """
        self._auth_configuration = auth_configuration

    @property
    def configuration(self):
        """
        Gets the configuration of this CreateMlApplicationInstanceDetails.
        Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.


        :return: The configuration of this CreateMlApplicationInstanceDetails.
        :rtype: list[oci.data_science.models.ConfigurationProperty]
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """
        Sets the configuration of this CreateMlApplicationInstanceDetails.
        Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.


        :param configuration: The configuration of this CreateMlApplicationInstanceDetails.
        :type: list[oci.data_science.models.ConfigurationProperty]
        """
        self._configuration = configuration

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this CreateMlApplicationInstanceDetails.
        Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.


        :return: The is_enabled of this CreateMlApplicationInstanceDetails.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this CreateMlApplicationInstanceDetails.
        Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.


        :param is_enabled: The is_enabled of this CreateMlApplicationInstanceDetails.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateMlApplicationInstanceDetails.
        The OCID of the compartment where the MlApplicationInstance is created.


        :return: The compartment_id of this CreateMlApplicationInstanceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateMlApplicationInstanceDetails.
        The OCID of the compartment where the MlApplicationInstance is created.


        :param compartment_id: The compartment_id of this CreateMlApplicationInstanceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateMlApplicationInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateMlApplicationInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateMlApplicationInstanceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateMlApplicationInstanceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateMlApplicationInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateMlApplicationInstanceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateMlApplicationInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateMlApplicationInstanceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
