# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .instance_component import InstanceComponent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataScienceScheduleInstanceComponent(InstanceComponent):
    """
    Data Science Schedule instance component
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataScienceScheduleInstanceComponent object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.DataScienceScheduleInstanceComponent.type` attribute
        of this class is ``DATA_SCIENCE_SCHEDULE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DataScienceScheduleInstanceComponent.
            Allowed values for this property are: "DATA_SCIENCE_MODEL_DEPLOYMENT", "OBJECT_STORAGE_BUCKET", "OBJECT_STORAGE_OBJECT", "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER", "DATA_SCIENCE_SCHEDULE", "GENERIC_OCI_RESOURCE"
        :type type: str

        :param name:
            The value to assign to the name property of this DataScienceScheduleInstanceComponent.
        :type name: str

        :param component_name:
            The value to assign to the component_name property of this DataScienceScheduleInstanceComponent.
        :type component_name: str

        :param schedule_id:
            The value to assign to the schedule_id property of this DataScienceScheduleInstanceComponent.
        :type schedule_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'component_name': 'str',
            'schedule_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'component_name': 'componentName',
            'schedule_id': 'scheduleId'
        }
        self._type = None
        self._name = None
        self._component_name = None
        self._schedule_id = None
        self._type = 'DATA_SCIENCE_SCHEDULE'

    @property
    def schedule_id(self):
        """
        **[Required]** Gets the schedule_id of this DataScienceScheduleInstanceComponent.
        OCID of Data Science Schedule


        :return: The schedule_id of this DataScienceScheduleInstanceComponent.
        :rtype: str
        """
        return self._schedule_id

    @schedule_id.setter
    def schedule_id(self, schedule_id):
        """
        Sets the schedule_id of this DataScienceScheduleInstanceComponent.
        OCID of Data Science Schedule


        :param schedule_id: The schedule_id of this DataScienceScheduleInstanceComponent.
        :type: str
        """
        self._schedule_id = schedule_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
