# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DisableMlApplicationInstanceViewTriggerDetails(object):
    """
    Payload for disable trigger action
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DisableMlApplicationInstanceViewTriggerDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param trigger_name:
            The value to assign to the trigger_name property of this DisableMlApplicationInstanceViewTriggerDetails.
        :type trigger_name: str

        """
        self.swagger_types = {
            'trigger_name': 'str'
        }
        self.attribute_map = {
            'trigger_name': 'triggerName'
        }
        self._trigger_name = None

    @property
    def trigger_name(self):
        """
        **[Required]** Gets the trigger_name of this DisableMlApplicationInstanceViewTriggerDetails.
        Name of trigger


        :return: The trigger_name of this DisableMlApplicationInstanceViewTriggerDetails.
        :rtype: str
        """
        return self._trigger_name

    @trigger_name.setter
    def trigger_name(self, trigger_name):
        """
        Sets the trigger_name of this DisableMlApplicationInstanceViewTriggerDetails.
        Name of trigger


        :param trigger_name: The trigger_name of this DisableMlApplicationInstanceViewTriggerDetails.
        :type: str
        """
        self._trigger_name = trigger_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
