# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .job_run_use_case_configuration_details import JobRunUseCaseConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenericJobRunUseCaseConfigurationDetails(JobRunUseCaseConfigurationDetails):
    """
    The evaluation use-case configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenericJobRunUseCaseConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.GenericJobRunUseCaseConfigurationDetails.use_case_type` attribute
        of this class is ``GENERIC`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param use_case_type:
            The value to assign to the use_case_type property of this GenericJobRunUseCaseConfigurationDetails.
            Allowed values for this property are: "GENERIC"
        :type use_case_type: str

        :param additional_configurations:
            The value to assign to the additional_configurations property of this GenericJobRunUseCaseConfigurationDetails.
        :type additional_configurations: dict(str, str)

        """
        self.swagger_types = {
            'use_case_type': 'str',
            'additional_configurations': 'dict(str, str)'
        }
        self.attribute_map = {
            'use_case_type': 'useCaseType',
            'additional_configurations': 'additionalConfigurations'
        }
        self._use_case_type = None
        self._additional_configurations = None
        self._use_case_type = 'GENERIC'

    @property
    def additional_configurations(self):
        """
        Gets the additional_configurations of this GenericJobRunUseCaseConfigurationDetails.
        The additional configurations


        :return: The additional_configurations of this GenericJobRunUseCaseConfigurationDetails.
        :rtype: dict(str, str)
        """
        return self._additional_configurations

    @additional_configurations.setter
    def additional_configurations(self, additional_configurations):
        """
        Sets the additional_configurations of this GenericJobRunUseCaseConfigurationDetails.
        The additional configurations


        :param additional_configurations: The additional_configurations of this GenericJobRunUseCaseConfigurationDetails.
        :type: dict(str, str)
        """
        self._additional_configurations = additional_configurations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
