# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobRunUseCaseConfigurationDetails(object):
    """
    The use-case configuration details
    """

    #: A constant which can be used with the use_case_type property of a JobRunUseCaseConfigurationDetails.
    #: This constant has a value of "GENERIC"
    USE_CASE_TYPE_GENERIC = "GENERIC"

    def __init__(self, **kwargs):
        """
        Initializes a new JobRunUseCaseConfigurationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.GenericJobRunUseCaseConfigurationDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param use_case_type:
            The value to assign to the use_case_type property of this JobRunUseCaseConfigurationDetails.
            Allowed values for this property are: "GENERIC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type use_case_type: str

        """
        self.swagger_types = {
            'use_case_type': 'str'
        }
        self.attribute_map = {
            'use_case_type': 'useCaseType'
        }
        self._use_case_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['useCaseType']

        if type == 'GENERIC':
            return 'GenericJobRunUseCaseConfigurationDetails'
        else:
            return 'JobRunUseCaseConfigurationDetails'

    @property
    def use_case_type(self):
        """
        **[Required]** Gets the use_case_type of this JobRunUseCaseConfigurationDetails.
        The job-run use-case.

        Allowed values for this property are: "GENERIC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The use_case_type of this JobRunUseCaseConfigurationDetails.
        :rtype: str
        """
        return self._use_case_type

    @use_case_type.setter
    def use_case_type(self, use_case_type):
        """
        Sets the use_case_type of this JobRunUseCaseConfigurationDetails.
        The job-run use-case.


        :param use_case_type: The use_case_type of this JobRunUseCaseConfigurationDetails.
        :type: str
        """
        allowed_values = ["GENERIC"]
        if not value_allowed_none_or_none_sentinel(use_case_type, allowed_values):
            use_case_type = 'UNKNOWN_ENUM_VALUE'
        self._use_case_type = use_case_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
