# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MlApplicationPackageArgumentDetails(object):
    """
    Represents single argument name value pair.
    """

    #: A constant which can be used with the type property of a MlApplicationPackageArgumentDetails.
    #: This constant has a value of "STRING"
    TYPE_STRING = "STRING"

    #: A constant which can be used with the type property of a MlApplicationPackageArgumentDetails.
    #: This constant has a value of "OCID"
    TYPE_OCID = "OCID"

    def __init__(self, **kwargs):
        """
        Initializes a new MlApplicationPackageArgumentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this MlApplicationPackageArgumentDetails.
        :type name: str

        :param value:
            The value to assign to the value property of this MlApplicationPackageArgumentDetails.
        :type value: str

        :param description:
            The value to assign to the description property of this MlApplicationPackageArgumentDetails.
        :type description: str

        :param type:
            The value to assign to the type property of this MlApplicationPackageArgumentDetails.
            Allowed values for this property are: "STRING", "OCID", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param is_mandatory:
            The value to assign to the is_mandatory property of this MlApplicationPackageArgumentDetails.
        :type is_mandatory: bool

        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str',
            'description': 'str',
            'type': 'str',
            'is_mandatory': 'bool'
        }
        self.attribute_map = {
            'name': 'name',
            'value': 'value',
            'description': 'description',
            'type': 'type',
            'is_mandatory': 'isMandatory'
        }
        self._name = None
        self._value = None
        self._description = None
        self._type = None
        self._is_mandatory = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this MlApplicationPackageArgumentDetails.
        Argument name


        :return: The name of this MlApplicationPackageArgumentDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MlApplicationPackageArgumentDetails.
        Argument name


        :param name: The name of this MlApplicationPackageArgumentDetails.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        **[Required]** Gets the value of this MlApplicationPackageArgumentDetails.
        Argument value


        :return: The value of this MlApplicationPackageArgumentDetails.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this MlApplicationPackageArgumentDetails.
        Argument value


        :param value: The value of this MlApplicationPackageArgumentDetails.
        :type: str
        """
        self._value = value

    @property
    def description(self):
        """
        **[Required]** Gets the description of this MlApplicationPackageArgumentDetails.
        short description of the argument


        :return: The description of this MlApplicationPackageArgumentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MlApplicationPackageArgumentDetails.
        short description of the argument


        :param description: The description of this MlApplicationPackageArgumentDetails.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        **[Required]** Gets the type of this MlApplicationPackageArgumentDetails.
        type of the argument

        Allowed values for this property are: "STRING", "OCID", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this MlApplicationPackageArgumentDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this MlApplicationPackageArgumentDetails.
        type of the argument


        :param type: The type of this MlApplicationPackageArgumentDetails.
        :type: str
        """
        allowed_values = ["STRING", "OCID"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def is_mandatory(self):
        """
        **[Required]** Gets the is_mandatory of this MlApplicationPackageArgumentDetails.
        argument is mandatory or not


        :return: The is_mandatory of this MlApplicationPackageArgumentDetails.
        :rtype: bool
        """
        return self._is_mandatory

    @is_mandatory.setter
    def is_mandatory(self, is_mandatory):
        """
        Sets the is_mandatory of this MlApplicationPackageArgumentDetails.
        argument is mandatory or not


        :param is_mandatory: The is_mandatory of this MlApplicationPackageArgumentDetails.
        :type: bool
        """
        self._is_mandatory = is_mandatory

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
