# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelDeploymentModelStateSummary(object):
    """
    Status of the model in a model group deployment.
    """

    #: A constant which can be used with the state property of a ModelDeploymentModelStateSummary.
    #: This constant has a value of "SUCCESS"
    STATE_SUCCESS = "SUCCESS"

    #: A constant which can be used with the state property of a ModelDeploymentModelStateSummary.
    #: This constant has a value of "FAILED"
    STATE_FAILED = "FAILED"

    #: A constant which can be used with the state property of a ModelDeploymentModelStateSummary.
    #: This constant has a value of "INCONSISTENT"
    STATE_INCONSISTENT = "INCONSISTENT"

    def __init__(self, **kwargs):
        """
        Initializes a new ModelDeploymentModelStateSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_id:
            The value to assign to the model_id property of this ModelDeploymentModelStateSummary.
        :type model_id: str

        :param project_id:
            The value to assign to the project_id property of this ModelDeploymentModelStateSummary.
        :type project_id: str

        :param display_name:
            The value to assign to the display_name property of this ModelDeploymentModelStateSummary.
        :type display_name: str

        :param inference_key:
            The value to assign to the inference_key property of this ModelDeploymentModelStateSummary.
        :type inference_key: str

        :param state:
            The value to assign to the state property of this ModelDeploymentModelStateSummary.
            Allowed values for this property are: "SUCCESS", "FAILED", "INCONSISTENT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ModelDeploymentModelStateSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ModelDeploymentModelStateSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ModelDeploymentModelStateSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'model_id': 'str',
            'project_id': 'str',
            'display_name': 'str',
            'inference_key': 'str',
            'state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'model_id': 'modelId',
            'project_id': 'projectId',
            'display_name': 'displayName',
            'inference_key': 'inferenceKey',
            'state': 'state',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._model_id = None
        self._project_id = None
        self._display_name = None
        self._inference_key = None
        self._state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def model_id(self):
        """
        **[Required]** Gets the model_id of this ModelDeploymentModelStateSummary.
        The `OCID`__ of the deployed model in model deployment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The model_id of this ModelDeploymentModelStateSummary.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this ModelDeploymentModelStateSummary.
        The `OCID`__ of the deployed model in model deployment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param model_id: The model_id of this ModelDeploymentModelStateSummary.
        :type: str
        """
        self._model_id = model_id

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this ModelDeploymentModelStateSummary.
        The `OCID`__ of the project associated with the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The project_id of this ModelDeploymentModelStateSummary.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this ModelDeploymentModelStateSummary.
        The `OCID`__ of the project associated with the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param project_id: The project_id of this ModelDeploymentModelStateSummary.
        :type: str
        """
        self._project_id = project_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ModelDeploymentModelStateSummary.
        A user-friendly display name for the resource.


        :return: The display_name of this ModelDeploymentModelStateSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ModelDeploymentModelStateSummary.
        A user-friendly display name for the resource.


        :param display_name: The display_name of this ModelDeploymentModelStateSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def inference_key(self):
        """
        **[Required]** Gets the inference_key of this ModelDeploymentModelStateSummary.
        SaaS friendly name for the model OCID.


        :return: The inference_key of this ModelDeploymentModelStateSummary.
        :rtype: str
        """
        return self._inference_key

    @inference_key.setter
    def inference_key(self, inference_key):
        """
        Sets the inference_key of this ModelDeploymentModelStateSummary.
        SaaS friendly name for the model OCID.


        :param inference_key: The inference_key of this ModelDeploymentModelStateSummary.
        :type: str
        """
        self._inference_key = inference_key

    @property
    def state(self):
        """
        **[Required]** Gets the state of this ModelDeploymentModelStateSummary.
        The state of the deployed model in model deployment.

        Allowed values for this property are: "SUCCESS", "FAILED", "INCONSISTENT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this ModelDeploymentModelStateSummary.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ModelDeploymentModelStateSummary.
        The state of the deployed model in model deployment.


        :param state: The state of this ModelDeploymentModelStateSummary.
        :type: str
        """
        allowed_values = ["SUCCESS", "FAILED", "INCONSISTENT"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ModelDeploymentModelStateSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ModelDeploymentModelStateSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ModelDeploymentModelStateSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ModelDeploymentModelStateSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ModelDeploymentModelStateSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ModelDeploymentModelStateSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ModelDeploymentModelStateSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ModelDeploymentModelStateSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ModelDeploymentModelStateSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ModelDeploymentModelStateSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ModelDeploymentModelStateSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ModelDeploymentModelStateSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
