# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .model_artifact_reference_details import ModelArtifactReferenceDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OSSModelArtifactReferenceDetails(ModelArtifactReferenceDetails):
    """
    Reference to the OSS where model artifact is stored
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OSSModelArtifactReferenceDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.OSSModelArtifactReferenceDetails.model_artifact_reference_type` attribute
        of this class is ``OSS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_artifact_reference_type:
            The value to assign to the model_artifact_reference_type property of this OSSModelArtifactReferenceDetails.
            Allowed values for this property are: "OSS"
        :type model_artifact_reference_type: str

        :param namespace:
            The value to assign to the namespace property of this OSSModelArtifactReferenceDetails.
        :type namespace: str

        :param bucket_name:
            The value to assign to the bucket_name property of this OSSModelArtifactReferenceDetails.
        :type bucket_name: str

        :param prefix:
            The value to assign to the prefix property of this OSSModelArtifactReferenceDetails.
        :type prefix: str

        """
        self.swagger_types = {
            'model_artifact_reference_type': 'str',
            'namespace': 'str',
            'bucket_name': 'str',
            'prefix': 'str'
        }
        self.attribute_map = {
            'model_artifact_reference_type': 'modelArtifactReferenceType',
            'namespace': 'namespace',
            'bucket_name': 'bucketName',
            'prefix': 'prefix'
        }
        self._model_artifact_reference_type = None
        self._namespace = None
        self._bucket_name = None
        self._prefix = None
        self._model_artifact_reference_type = 'OSS'

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this OSSModelArtifactReferenceDetails.
        The namespace of the model artifact reference in OSS.


        :return: The namespace of this OSSModelArtifactReferenceDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this OSSModelArtifactReferenceDetails.
        The namespace of the model artifact reference in OSS.


        :param namespace: The namespace of this OSSModelArtifactReferenceDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this OSSModelArtifactReferenceDetails.
        The bucket name of the model artifact reference in OSS.


        :return: The bucket_name of this OSSModelArtifactReferenceDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this OSSModelArtifactReferenceDetails.
        The bucket name of the model artifact reference in OSS.


        :param bucket_name: The bucket_name of this OSSModelArtifactReferenceDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def prefix(self):
        """
        Gets the prefix of this OSSModelArtifactReferenceDetails.
        The prefix of the model artifact reference in OSS.


        :return: The prefix of this OSSModelArtifactReferenceDetails.
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """
        Sets the prefix of this OSSModelArtifactReferenceDetails.
        The prefix of the model artifact reference in OSS.


        :param prefix: The prefix of this OSSModelArtifactReferenceDetails.
        :type: str
        """
        self._prefix = prefix

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
