# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineShapeConfigDetails(object):
    """
    Details for the pipeline step run shape configuration. Specify only when a flex shape is selected.
    """

    #: A constant which can be used with the cpu_baseline property of a PipelineShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_8"
    CPU_BASELINE_BASELINE_1_8 = "BASELINE_1_8"

    #: A constant which can be used with the cpu_baseline property of a PipelineShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_2"
    CPU_BASELINE_BASELINE_1_2 = "BASELINE_1_2"

    #: A constant which can be used with the cpu_baseline property of a PipelineShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_1"
    CPU_BASELINE_BASELINE_1_1 = "BASELINE_1_1"

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineShapeConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ocpus:
            The value to assign to the ocpus property of this PipelineShapeConfigDetails.
        :type ocpus: float

        :param memory_in_gbs:
            The value to assign to the memory_in_gbs property of this PipelineShapeConfigDetails.
        :type memory_in_gbs: float

        :param cpu_baseline:
            The value to assign to the cpu_baseline property of this PipelineShapeConfigDetails.
            Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cpu_baseline: str

        :param ocpus_parameterized:
            The value to assign to the ocpus_parameterized property of this PipelineShapeConfigDetails.
        :type ocpus_parameterized: str

        :param memory_in_gbs_parameterized:
            The value to assign to the memory_in_gbs_parameterized property of this PipelineShapeConfigDetails.
        :type memory_in_gbs_parameterized: str

        """
        self.swagger_types = {
            'ocpus': 'float',
            'memory_in_gbs': 'float',
            'cpu_baseline': 'str',
            'ocpus_parameterized': 'str',
            'memory_in_gbs_parameterized': 'str'
        }
        self.attribute_map = {
            'ocpus': 'ocpus',
            'memory_in_gbs': 'memoryInGBs',
            'cpu_baseline': 'cpuBaseline',
            'ocpus_parameterized': 'ocpusParameterized',
            'memory_in_gbs_parameterized': 'memoryInGBsParameterized'
        }
        self._ocpus = None
        self._memory_in_gbs = None
        self._cpu_baseline = None
        self._ocpus_parameterized = None
        self._memory_in_gbs_parameterized = None

    @property
    def ocpus(self):
        """
        Gets the ocpus of this PipelineShapeConfigDetails.
        The total number of OCPUs available to the pipeline step run instance.


        :return: The ocpus of this PipelineShapeConfigDetails.
        :rtype: float
        """
        return self._ocpus

    @ocpus.setter
    def ocpus(self, ocpus):
        """
        Sets the ocpus of this PipelineShapeConfigDetails.
        The total number of OCPUs available to the pipeline step run instance.


        :param ocpus: The ocpus of this PipelineShapeConfigDetails.
        :type: float
        """
        self._ocpus = ocpus

    @property
    def memory_in_gbs(self):
        """
        Gets the memory_in_gbs of this PipelineShapeConfigDetails.
        The total amount of memory available to the pipeline step run instance GBs.


        :return: The memory_in_gbs of this PipelineShapeConfigDetails.
        :rtype: float
        """
        return self._memory_in_gbs

    @memory_in_gbs.setter
    def memory_in_gbs(self, memory_in_gbs):
        """
        Sets the memory_in_gbs of this PipelineShapeConfigDetails.
        The total amount of memory available to the pipeline step run instance GBs.


        :param memory_in_gbs: The memory_in_gbs of this PipelineShapeConfigDetails.
        :type: float
        """
        self._memory_in_gbs = memory_in_gbs

    @property
    def cpu_baseline(self):
        """
        Gets the cpu_baseline of this PipelineShapeConfigDetails.
        The baseline OCPU utilization for a subcore burstable VM instance. If this attribute is left blank, it will default to `BASELINE_1_1`.
        The following values are supported:
          BASELINE_1_8 - baseline usage is 1/8 of an OCPU.
          BASELINE_1_2 - baseline usage is 1/2 of an OCPU.
          BASELINE_1_1 - baseline usage is an entire OCPU. This represents a non-burstable instance.

        Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cpu_baseline of this PipelineShapeConfigDetails.
        :rtype: str
        """
        return self._cpu_baseline

    @cpu_baseline.setter
    def cpu_baseline(self, cpu_baseline):
        """
        Sets the cpu_baseline of this PipelineShapeConfigDetails.
        The baseline OCPU utilization for a subcore burstable VM instance. If this attribute is left blank, it will default to `BASELINE_1_1`.
        The following values are supported:
          BASELINE_1_8 - baseline usage is 1/8 of an OCPU.
          BASELINE_1_2 - baseline usage is 1/2 of an OCPU.
          BASELINE_1_1 - baseline usage is an entire OCPU. This represents a non-burstable instance.


        :param cpu_baseline: The cpu_baseline of this PipelineShapeConfigDetails.
        :type: str
        """
        allowed_values = ["BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1"]
        if not value_allowed_none_or_none_sentinel(cpu_baseline, allowed_values):
            cpu_baseline = 'UNKNOWN_ENUM_VALUE'
        self._cpu_baseline = cpu_baseline

    @property
    def ocpus_parameterized(self):
        """
        Gets the ocpus_parameterized of this PipelineShapeConfigDetails.
        The total number of OCPUs available to the pipeline step run instance specified as a parameter. This overrides the ocpus value.
        The request will fail if the parameters used are null or invalid.


        :return: The ocpus_parameterized of this PipelineShapeConfigDetails.
        :rtype: str
        """
        return self._ocpus_parameterized

    @ocpus_parameterized.setter
    def ocpus_parameterized(self, ocpus_parameterized):
        """
        Sets the ocpus_parameterized of this PipelineShapeConfigDetails.
        The total number of OCPUs available to the pipeline step run instance specified as a parameter. This overrides the ocpus value.
        The request will fail if the parameters used are null or invalid.


        :param ocpus_parameterized: The ocpus_parameterized of this PipelineShapeConfigDetails.
        :type: str
        """
        self._ocpus_parameterized = ocpus_parameterized

    @property
    def memory_in_gbs_parameterized(self):
        """
        Gets the memory_in_gbs_parameterized of this PipelineShapeConfigDetails.
        The total amount of memory available to the pipeline step run instance in GBs specified as a parameter. This overrides the memoryInGBs value.
        The request will fail if the parameters used are null or invalid.


        :return: The memory_in_gbs_parameterized of this PipelineShapeConfigDetails.
        :rtype: str
        """
        return self._memory_in_gbs_parameterized

    @memory_in_gbs_parameterized.setter
    def memory_in_gbs_parameterized(self, memory_in_gbs_parameterized):
        """
        Sets the memory_in_gbs_parameterized of this PipelineShapeConfigDetails.
        The total amount of memory available to the pipeline step run instance in GBs specified as a parameter. This overrides the memoryInGBs value.
        The request will fail if the parameters used are null or invalid.


        :param memory_in_gbs_parameterized: The memory_in_gbs_parameterized of this PipelineShapeConfigDetails.
        :type: str
        """
        self._memory_in_gbs_parameterized = memory_in_gbs_parameterized

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
