# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutonomousDatabaseMaintenanceWindowSummary(object):
    """
    Autonomous AI Database maintenance window. The maintenance window can be configured during database creation. To change the maintenance window of an existing Autonomous AI Database Serverless instance, clone the database and specify the maintenance window for the new cloned instance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AutonomousDatabaseMaintenanceWindowSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param day_of_week:
            The value to assign to the day_of_week property of this AutonomousDatabaseMaintenanceWindowSummary.
        :type day_of_week: oci.database.models.DayOfWeek

        :param maintenance_start_time:
            The value to assign to the maintenance_start_time property of this AutonomousDatabaseMaintenanceWindowSummary.
        :type maintenance_start_time: str

        :param maintenance_end_time:
            The value to assign to the maintenance_end_time property of this AutonomousDatabaseMaintenanceWindowSummary.
        :type maintenance_end_time: str

        """
        self.swagger_types = {
            'day_of_week': 'DayOfWeek',
            'maintenance_start_time': 'str',
            'maintenance_end_time': 'str'
        }
        self.attribute_map = {
            'day_of_week': 'dayOfWeek',
            'maintenance_start_time': 'maintenanceStartTime',
            'maintenance_end_time': 'maintenanceEndTime'
        }
        self._day_of_week = None
        self._maintenance_start_time = None
        self._maintenance_end_time = None

    @property
    def day_of_week(self):
        """
        **[Required]** Gets the day_of_week of this AutonomousDatabaseMaintenanceWindowSummary.

        :return: The day_of_week of this AutonomousDatabaseMaintenanceWindowSummary.
        :rtype: oci.database.models.DayOfWeek
        """
        return self._day_of_week

    @day_of_week.setter
    def day_of_week(self, day_of_week):
        """
        Sets the day_of_week of this AutonomousDatabaseMaintenanceWindowSummary.

        :param day_of_week: The day_of_week of this AutonomousDatabaseMaintenanceWindowSummary.
        :type: oci.database.models.DayOfWeek
        """
        self._day_of_week = day_of_week

    @property
    def maintenance_start_time(self):
        """
        Gets the maintenance_start_time of this AutonomousDatabaseMaintenanceWindowSummary.
        The maintenance start time. The value must use the ISO-8601 format \"hh:mm\".


        :return: The maintenance_start_time of this AutonomousDatabaseMaintenanceWindowSummary.
        :rtype: str
        """
        return self._maintenance_start_time

    @maintenance_start_time.setter
    def maintenance_start_time(self, maintenance_start_time):
        """
        Sets the maintenance_start_time of this AutonomousDatabaseMaintenanceWindowSummary.
        The maintenance start time. The value must use the ISO-8601 format \"hh:mm\".


        :param maintenance_start_time: The maintenance_start_time of this AutonomousDatabaseMaintenanceWindowSummary.
        :type: str
        """
        self._maintenance_start_time = maintenance_start_time

    @property
    def maintenance_end_time(self):
        """
        Gets the maintenance_end_time of this AutonomousDatabaseMaintenanceWindowSummary.
        The maintenance end time. The value must use the ISO-8601 format \"hh:mm\".


        :return: The maintenance_end_time of this AutonomousDatabaseMaintenanceWindowSummary.
        :rtype: str
        """
        return self._maintenance_end_time

    @maintenance_end_time.setter
    def maintenance_end_time(self, maintenance_end_time):
        """
        Sets the maintenance_end_time of this AutonomousDatabaseMaintenanceWindowSummary.
        The maintenance end time. The value must use the ISO-8601 format \"hh:mm\".


        :param maintenance_end_time: The maintenance_end_time of this AutonomousDatabaseMaintenanceWindowSummary.
        :type: str
        """
        self._maintenance_end_time = maintenance_end_time

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
