# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutonomousDatabaseSoftwareImageSummary(object):
    """
    The Database service supports the creation of Autonomous AI Database Software Images for use in creating Autonomous Container Database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AutonomousDatabaseSoftwareImageSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AutonomousDatabaseSoftwareImageSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AutonomousDatabaseSoftwareImageSummary.
        :type compartment_id: str

        :param database_version:
            The value to assign to the database_version property of this AutonomousDatabaseSoftwareImageSummary.
        :type database_version: str

        :param display_name:
            The value to assign to the display_name property of this AutonomousDatabaseSoftwareImageSummary.
        :type display_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AutonomousDatabaseSoftwareImageSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this AutonomousDatabaseSoftwareImageSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this AutonomousDatabaseSoftwareImageSummary.
        :type time_created: datetime

        :param release_update:
            The value to assign to the release_update property of this AutonomousDatabaseSoftwareImageSummary.
        :type release_update: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AutonomousDatabaseSoftwareImageSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AutonomousDatabaseSoftwareImageSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AutonomousDatabaseSoftwareImageSummary.
        :type system_tags: dict(str, dict(str, object))

        :param autonomous_dsi_one_off_patches:
            The value to assign to the autonomous_dsi_one_off_patches property of this AutonomousDatabaseSoftwareImageSummary.
        :type autonomous_dsi_one_off_patches: list[str]

        :param image_shape_family:
            The value to assign to the image_shape_family property of this AutonomousDatabaseSoftwareImageSummary.
        :type image_shape_family: str

        :param dst_file_version:
            The value to assign to the dst_file_version property of this AutonomousDatabaseSoftwareImageSummary.
        :type dst_file_version: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'database_version': 'str',
            'display_name': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'release_update': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'autonomous_dsi_one_off_patches': 'list[str]',
            'image_shape_family': 'str',
            'dst_file_version': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'database_version': 'databaseVersion',
            'display_name': 'displayName',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'release_update': 'releaseUpdate',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'autonomous_dsi_one_off_patches': 'autonomousDsiOneOffPatches',
            'image_shape_family': 'imageShapeFamily',
            'dst_file_version': 'dstFileVersion'
        }
        self._id = None
        self._compartment_id = None
        self._database_version = None
        self._display_name = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._release_update = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._autonomous_dsi_one_off_patches = None
        self._image_shape_family = None
        self._dst_file_version = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AutonomousDatabaseSoftwareImageSummary.
        The `OCID`__ of the Autonomous AI Database Software Image.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AutonomousDatabaseSoftwareImageSummary.
        The `OCID`__ of the Autonomous AI Database Software Image.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AutonomousDatabaseSoftwareImageSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AutonomousDatabaseSoftwareImageSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def database_version(self):
        """
        **[Required]** Gets the database_version of this AutonomousDatabaseSoftwareImageSummary.
        The database version with which the Autonomous AI Database Software Image is to be built.


        :return: The database_version of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._database_version

    @database_version.setter
    def database_version(self, database_version):
        """
        Sets the database_version of this AutonomousDatabaseSoftwareImageSummary.
        The database version with which the Autonomous AI Database Software Image is to be built.


        :param database_version: The database_version of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._database_version = database_version

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AutonomousDatabaseSoftwareImageSummary.
        The user-friendly name for the Autonomous AI Database Software Image. The name does not have to be unique.


        :return: The display_name of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AutonomousDatabaseSoftwareImageSummary.
        The user-friendly name for the Autonomous AI Database Software Image. The name does not have to be unique.


        :param display_name: The display_name of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AutonomousDatabaseSoftwareImageSummary.
        The current state of the Autonomous AI Database Software Image.


        :return: The lifecycle_state of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AutonomousDatabaseSoftwareImageSummary.
        The current state of the Autonomous AI Database Software Image.


        :param lifecycle_state: The lifecycle_state of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this AutonomousDatabaseSoftwareImageSummary.
        Detailed message for the lifecycle state.


        :return: The lifecycle_details of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this AutonomousDatabaseSoftwareImageSummary.
        Detailed message for the lifecycle state.


        :param lifecycle_details: The lifecycle_details of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this AutonomousDatabaseSoftwareImageSummary.
        The date and time the Autonomous AI Database Software Image was created.


        :return: The time_created of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AutonomousDatabaseSoftwareImageSummary.
        The date and time the Autonomous AI Database Software Image was created.


        :param time_created: The time_created of this AutonomousDatabaseSoftwareImageSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def release_update(self):
        """
        **[Required]** Gets the release_update of this AutonomousDatabaseSoftwareImageSummary.
        The Release Updates.


        :return: The release_update of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._release_update

    @release_update.setter
    def release_update(self, release_update):
        """
        Sets the release_update of this AutonomousDatabaseSoftwareImageSummary.
        The Release Updates.


        :param release_update: The release_update of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._release_update = release_update

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AutonomousDatabaseSoftwareImageSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AutonomousDatabaseSoftwareImageSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this AutonomousDatabaseSoftwareImageSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AutonomousDatabaseSoftwareImageSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AutonomousDatabaseSoftwareImageSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this AutonomousDatabaseSoftwareImageSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AutonomousDatabaseSoftwareImageSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AutonomousDatabaseSoftwareImageSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this AutonomousDatabaseSoftwareImageSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def autonomous_dsi_one_off_patches(self):
        """
        Gets the autonomous_dsi_one_off_patches of this AutonomousDatabaseSoftwareImageSummary.
        One-off patches included in the Autonomous AI Database Software Image


        :return: The autonomous_dsi_one_off_patches of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: list[str]
        """
        return self._autonomous_dsi_one_off_patches

    @autonomous_dsi_one_off_patches.setter
    def autonomous_dsi_one_off_patches(self, autonomous_dsi_one_off_patches):
        """
        Sets the autonomous_dsi_one_off_patches of this AutonomousDatabaseSoftwareImageSummary.
        One-off patches included in the Autonomous AI Database Software Image


        :param autonomous_dsi_one_off_patches: The autonomous_dsi_one_off_patches of this AutonomousDatabaseSoftwareImageSummary.
        :type: list[str]
        """
        self._autonomous_dsi_one_off_patches = autonomous_dsi_one_off_patches

    @property
    def image_shape_family(self):
        """
        **[Required]** Gets the image_shape_family of this AutonomousDatabaseSoftwareImageSummary.
        To what shape the image is meant for.


        :return: The image_shape_family of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._image_shape_family

    @image_shape_family.setter
    def image_shape_family(self, image_shape_family):
        """
        Sets the image_shape_family of this AutonomousDatabaseSoftwareImageSummary.
        To what shape the image is meant for.


        :param image_shape_family: The image_shape_family of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._image_shape_family = image_shape_family

    @property
    def dst_file_version(self):
        """
        Gets the dst_file_version of this AutonomousDatabaseSoftwareImageSummary.
        DST Time-Zone File version of the Autonomous Container Database.


        :return: The dst_file_version of this AutonomousDatabaseSoftwareImageSummary.
        :rtype: str
        """
        return self._dst_file_version

    @dst_file_version.setter
    def dst_file_version(self, dst_file_version):
        """
        Sets the dst_file_version of this AutonomousDatabaseSoftwareImageSummary.
        DST Time-Zone File version of the Autonomous Container Database.


        :param dst_file_version: The dst_file_version of this AutonomousDatabaseSoftwareImageSummary.
        :type: str
        """
        self._dst_file_version = dst_file_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
