# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .encryption_key_location_details import EncryptionKeyLocationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AwsEncryptionKeyDetails(EncryptionKeyLocationDetails):
    """
    Details for AWS Input
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AwsEncryptionKeyDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.AwsEncryptionKeyDetails.provider_type` attribute
        of this class is ``AWS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider_type:
            The value to assign to the provider_type property of this AwsEncryptionKeyDetails.
            Allowed values for this property are: "EXTERNAL", "AZURE", "GCP", "AWS"
        :type provider_type: str

        :param aws_encryption_key_id:
            The value to assign to the aws_encryption_key_id property of this AwsEncryptionKeyDetails.
        :type aws_encryption_key_id: str

        """
        self.swagger_types = {
            'provider_type': 'str',
            'aws_encryption_key_id': 'str'
        }
        self.attribute_map = {
            'provider_type': 'providerType',
            'aws_encryption_key_id': 'awsEncryptionKeyId'
        }
        self._provider_type = None
        self._aws_encryption_key_id = None
        self._provider_type = 'AWS'

    @property
    def aws_encryption_key_id(self):
        """
        **[Required]** Gets the aws_encryption_key_id of this AwsEncryptionKeyDetails.
        Provide the key OCID of a registered AWS key.


        :return: The aws_encryption_key_id of this AwsEncryptionKeyDetails.
        :rtype: str
        """
        return self._aws_encryption_key_id

    @aws_encryption_key_id.setter
    def aws_encryption_key_id(self, aws_encryption_key_id):
        """
        Sets the aws_encryption_key_id of this AwsEncryptionKeyDetails.
        Provide the key OCID of a registered AWS key.


        :param aws_encryption_key_id: The aws_encryption_key_id of this AwsEncryptionKeyDetails.
        :type: str
        """
        self._aws_encryption_key_id = aws_encryption_key_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
